<?php
namespace admin\components;

use Yii;
use yii\base\Component;
// use admin\components\AccessComponent;

class MenuComponent extends Component{

	public static function getArrOfMenu($currentController = '', $currentAction = '', $currentModule = '')
	{
		return array(
			array(
				'label' => 'Dashboard',
				'url' => 'dashboard',
				'icon' => 'mbri-home',
				'active' => $currentController == 'dashboard' || $currentAction == "myprofile" ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Orders',
				'url' => 'order',
				'icon' => 'mbri-sale',
				'active' => $currentModule == 'order' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Payment Confirmation',
				'url' => 'paymentconfirmation',
				'icon' => 'mbri-cash',
				'active' => $currentModule == 'paymentconfirmation' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Product',
				'url' => '#',
				'icon' => 'mbri-database',
				'active' => $currentModule == 'product' ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'Attributes',
						'url' => 'product/attribute',
						'icon' => 'la la-barcode',
						'active' => $currentModule == 'product' && $currentController == 'attribute' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Categoies',
						'url' => 'product/category',
						'icon' => 'la la-adjust',
						'active' => $currentModule == 'product' && $currentController == 'category' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Products',
						'url' => 'product/default',
						'icon' => 'la la-codepen',
						'active' => $currentModule == 'product' && $currentController == 'default' ? true : false,
						'visible' => true
					],
				),
			),
			array(
				'label' => 'Member',
				'url' => 'member',
				'icon' => 'mbri-user',
				'active' => $currentModule == 'member' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Slide',
				'url' => 'slide',
				'icon' => 'mbri-image-slider',
				'active' => $currentModule == 'slide' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Delivery Fee',
				'url' => '#',
				'icon' => 'mbri-delivery',
				'active' => $currentModule == 'deliveryfee' ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'City',
						'url' => 'deliveryfee/city',
						'icon' => 'la la-building',
						'active' => $currentModule == 'deliveryfee' && $currentController == 'city' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Province',
						'url' => 'deliveryfee/province',
						'icon' => 'la la-university',
						'active' => $currentModule == 'deliveryfee' && $currentController == 'province' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Delivery Fee',
						'url' => 'deliveryfee/default',
						'icon' => 'la la-newspaper-o',
						'active' => $currentModule == 'deliveryfee' && $currentController == 'default' ? true : false,
						'visible' => true
					],
				),
			),
			array(
				'label' => 'Voucher',
				'url' => 'voucher',
				'icon' => 'mbri-bookmark',
				'active' => $currentModule == 'voucher' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Setting',
				'url' => '#',
				'icon' => 'mbri-setting',
				'active' => in_array($currentModule, array('setting')) ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'Setting',
						'url' => 'setting',
						'icon' => 'la la-gear',
						'active' => $currentModule == 'setting' && $currentController == 'default' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Profil',
						'url' => 'setting/profile/myprofile',
						'icon' => 'la la-user',
						'active' => $currentModule == 'setting' && $currentController == 'profile' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Ganti Password',
						'url' => 'setting/user/changepassword',
						'icon' => 'la la-key',
						'active' => $currentModule == 'setting' && $currentController == 'user' ? true : false,
						'visible' => true,
					],
					[
						'label' => 'Logout',
						'url' => 'site/logout',
						'icon' => 'la la-sign-out',
						'visible' => true,
					],
				),
			),
		);
	}
}
