<?php
namespace admin\components;

use Yii;
use yii\base\Component;

class StringComponent extends Component
{
	/* truncate a long html coded text without stripping the codes */
	public static function csubstr($string, $start, $length = FALSE)
	{
		$pattern = '/(\[\w+[^\]]*?\]|\[\/\w+\]|<\w+[^>]*?>|<\/\w+>)/i';
		$clean   = preg_replace($pattern, chr(1), $string);
		if (!$length)
			$str = substr($clean, $start);
		else {
			$str = substr($clean, $start, $length);
			$str = substr($clean, $start, $length + substr_count($str, chr(1)));
		}
		$pattern = str_replace(chr(1), '(.*?)', preg_quote($str));
		if (preg_match('~' . $pattern . '~is', $string, $matched))
			return strlen($clean) > $length ? $matched[0] . " ... " : $matched[0];

		return $string;
	}

	public static function slug($text)
	{
		//return strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $string)));
		// replace non letter or digits by -
		$text = preg_replace('~[^\pL\d]+~u', '-', $text);
		// transliterate
		$text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
		// remove unwanted characters
		$text = preg_replace('~[^-\w]+~', '', $text);
		// trim
		$text = trim($text, '-');
		// remove duplicate -
		$text = preg_replace('~-+~', '-', $text);
		// lowercase
		$text = strtolower($text);
		
		if (empty($text))
			return 'n-a';
		  
		return $text;
	}

	public static function randomToken($muncul){

		if($muncul == '10'){
			$ryRandom = rand(1111111111,9999999999); //*Acak angka 1111111111 - 9999999999 menampilkan 10 angka
		}
		elseif($muncul == '9'){
			$ryRandom = rand(111111111,999999999); //*Acak angka 111111111 - 999999999 menampilkan 9 angka
		}
		elseif($muncul == '8'){
			$ryRandom = rand(11111111,99999999); //*Acak angka 11111111 - 99999999 menampilkan 8 angka
		}
		elseif($muncul == '7'){
			$ryRandom = rand(1111111,9999999); //*Acak angka 1111111 - 9999999 menampilkan 7 angka
		}
		elseif($muncul == '6'){
			$ryRandom = rand(111111,999999); //*Acak angka 111111 - 999999 menampilkan 6 angka
		}
		elseif($muncul == '5'){
			$ryRandom = rand(11111,99999); //*Acak angka 11111 - 99999 menampilkan 5 angka
		}
		elseif($muncul == '4'){
			$ryRandom = rand(1111,9999); //*Acak angka 1111 - 9999 menampilkan 4 angka
		}
		elseif($muncul == '3'){
			$ryRandom = rand(111,999); //*Acak angka 111 - 999 menampilkan 3 angka
		}
		elseif($muncul == '2'){
			$ryRandom = rand(11,99); //* menampilkan 2 angka
		}
		else{
		    $ryRandom = "Random belum di setting";
		}
		return $ryRandom;
	}
}
?>