<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\DeliveryCity;

/**
 * DeliveryCitySearch represents the model behind the search form of `common\models\DeliveryCity`.
 */
class DeliveryCitySearch extends DeliveryCity
{
    public $province_name;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'city_id', 'province_id'], 'integer'],
            [['city_type', 'city_name', 'city_postal_code', 'province_name'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = DeliveryCity::find();
        $query->joinWith(['province AS province']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'attributes' => [
                    'city_name',
                    'city_type',
                    'city_postal_code',
                    'province_name' => [
                        'asc' => ['province.province_name' => SORT_ASC],
                        'desc' => ['province.province_name' => SORT_DESC],
                    ],
                ],
                'defaultOrder' => ['city_name' => SORT_ASC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'city_id' => $this->city_id,
            'province_id' => $this->province_id,
        ]);

        $query->andFilterWhere(['like', 'city_type', $this->city_type])
            ->andFilterWhere(['like', 'city_name', $this->city_name])
            ->andFilterWhere(['like', 'province.province_name', $this->province_name])
            ->andFilterWhere(['like', 'city_postal_code', $this->city_postal_code]);

        return $dataProvider;
    }
}
