<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\DeliveryFee;

/**
 * DeliveryFeeSearch represents the model behind the search form of `common\models\DeliveryFee`.
 */
class DeliveryFeeSearch extends DeliveryFee
{
     public $origin_city, $dest_city;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'origin_city_id', 'destination_city_id'], 'integer'],
            [['fee_value'], 'number'],
            [['dest_city', 'origin_city', 'dest_province'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = DeliveryFee::find();
        $query->joinWith(['destinationCity AS dest', 'originCity AS origin', 'destinationCity.province AS destProvince']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'attributes' => [
                    'fee_value',
                    'origin_city' => [
                        'asc' => ['origin.city_name' => SORT_ASC],
                        'desc' => ['origin.city_name' => SORT_DESC],
                    ],
                    'dest_province' => [
                        'asc' => ['destProvince.province_name' => SORT_ASC],
                        'desc' => ['destProvince.province_name' => SORT_DESC],
                    ],
                    'dest_city' => [
                        'asc' => ['dest.city_name' => SORT_ASC],
                        'desc' => ['dest.city_name' => SORT_DESC],
                    ],
                ],
                'defaultOrder' => ['dest_province' => SORT_ASC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'origin_city_id' => $this->origin_city_id,
            'destination_city_id' => $this->destination_city_id,
            'fee_value' => $this->fee_value,
        ]);

        $query->andFilterWhere(['like', 'origin.city_name', $this->origin_city])
            ->andFilterWhere(['like', 'dest.city_name', $this->dest_city])
            ->andFilterWhere(['like', 'destProvince.province_name', $this->dest_province]);

        return $dataProvider;
    }
}
