<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Inventory;

/**
 * InventorySearch represents the model behind the search form of `common\models\Inventory`.
 */
class InventorySearch extends Inventory
{
    public $product_name, $product_price, $product_sale_price;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'product_id', 'product_attribute_group_id', 'inventory_stock'], 'integer'],
            [['product_name', 'product_price', 'product_sale_price'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Inventory::find();
        $query->joinWith(['product AS product']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'attributes' => [
                    'product_name' => [
                        'asc' => ['product.product_name' => SORT_ASC],
                        'desc' => ['product.product_name' => SORT_DESC],
                    ],
                    'product_price' => [
                        'asc' => ['product.product_price' => SORT_ASC],
                        'desc' => ['product.product_price' => SORT_DESC],
                    ],
                    'product_sale_price' => [
                        'asc' => ['product.product_sale_price' => SORT_ASC],
                        'desc' => ['product.product_sale_price' => SORT_DESC],
                    ],
                    'inventory_stock',
                ],
                'defaultOrder' => ['product_name' => SORT_ASC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'product_id' => $this->product_id,
            'product_attribute_group_id' => $this->product_attribute_group_id,
            'inventory_stock' => $this->inventory_stock,
            'product.is_deleted' => 0,
        ]);

        $query->andFilterWhere(['like', 'product.product_name', $this->product_name]);

        return $dataProvider;
    }
}
