<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Product;

/**
 * ProductSearch represents the model behind the search form of `common\models\Product`.
 */
class ProductSearch extends Product
{
    public $category_name;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'category_id', 'created_by', 'updated_by', 'is_deleted'], 'integer'],
            [['product_name', 'product_slug', 'product_desc', 'product_status', 'created_on', 'updated_on', 'category_name'], 'safe'],
            [['product_price', 'product_sale_price', 'product_weight_in_gram'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Product::find();
        $query->joinWith(['category AS category']);
        // $query->orderBy(['COALESCE(tbl_product.updated_on, tbl_product.created_on)' => SORT_DESC]);
        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'attributes' => [
                    'product_name',
                    'product_price',
                    'product_sale_price',
                    'product_desc',
                    'product_status',
                    'product_weight_in_gram',
                    'updated_on',
                    'created_on',
                    'COALESCE(tbl_product.updated_on, tbl_product.created_on)',
                    'category_name' => [
                        'asc' => ['category.category_name' => SORT_ASC],
                        'desc' => ['category.category_name' => SORT_DESC],
                    ],
                ],
                'defaultOrder' => ['COALESCE(tbl_product.updated_on, tbl_product.created_on)' => SORT_DESC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'category_id' => $this->category_id,
            'product_price' => $this->product_price,
            'product_sale_price' => $this->product_sale_price,
            'product_weight_in_gram' => $this->product_weight_in_gram,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_on' => $this->created_on,
            'updated_on' => $this->updated_on,
            'tbl_product.is_deleted' => 0,
        ]);

        $query->andFilterWhere(['like', 'product_name', $this->product_name])
            ->andFilterWhere(['like', 'product_slug', $this->product_slug])
            ->andFilterWhere(['like', 'product_desc', $this->product_desc])
            ->andFilterWhere(['like', 'product_status', $this->product_status])
            ->andFilterWhere(['like', 'category.category_name', $this->category_name]);

        return $dataProvider;
    }
}
