<?php

namespace admin\modules\deliveryfee\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\DeliveryCity;
use common\models\DeliveryProvince;
use common\components\ErrorGenerateComponent;
use admin\components\DeliveryCostComponent;
use admin\models\DeliveryCitySearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class CityController extends BaseController
{

  public function actionIndex()
    {
          BaseController::$page_caption = 'City';

          $searchModel = new DeliveryCitySearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
    }

  public function actionSyncron()
  {
      $data = json_decode(DeliveryCostComponent::getCitiesJSON());
      // print_r($data->rajaongkir->results);
      // exit();
      $noProblem = true;
      $trans = Yii::$app->db->beginTransaction();

      $count = 0;
      
      if ($data->rajaongkir->status->code == "200") {
          $arr = array();
          foreach($data->rajaongkir->results as $result) {

              $city = DeliveryCity::find()->andWhere('city_id = :c_id', [':c_id' => $result->city_id])->one();
              if(empty($city)){
                  $temp = new DeliveryCity();
                  $temp->city_id = $result->city_id;
                  $temp->city_name = $result->city_name;
                  $temp->city_type = $result->type;
                  $temp->city_postal_code = $result->postal_code;

                  $province = DeliveryProvince::find()->andWhere('province_id = :p_id', [':p_id' => $result->province_id])->one();

                  if(!empty($province)){
                      
                      $temp->province_id = $province->id;
                      if(!$temp->save()){
                          $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                          $noProblem = false;
                          Yii::$app->session->setFlash('danger', $errorMessage);
                          break;
                      }

                      $count++;  
                  }
                  else{
                      array_push($arr, $result->province);
                  }
              }
          }

          if($noProblem && !empty($arr)){
              // Yii::$app->session->setFlash('danger', 'Provinces : '.implode(', ', $arr).' not found, please Synchronize the province.');
            Yii::$app->session->setFlash('danger', 'Some Provinces are not found, please Synchronize the province first.');
              $noProblem = false;
          }
      }
      else{
          $noProblem = false;
          Yii::$app->session->setFlash('danger', 'error from server.');
      }

      if ($noProblem) {
          $trans->commit();
          if($count > 0)
            Yii::$app->session->setFlash('success', 'Synchronisation is successfully done. '.$count.' new cities is downloaded.');
          else
            Yii::$app->session->setFlash('success', 'Nothing downloaded. The data cities is complete.');
      }

      return $this->redirect(['index']);
  }

    public function actionDelete($id)
    {
      $model = $this->findModel($id);
      if($model->getIsDataUsed()){
          Yii::$app->session->setFlash('danger', 'cannot delete '.$model->city_name.' because is used.');
      }
      else{
          $model->delete();
          Yii::$app->session->setFlash('success', 'City '.LabelComponent::SUCCESS_DELETE);
      }

      return $this->redirect(['index']);
    }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = DeliveryCity::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
