<?php

namespace admin\modules\deliveryfee\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\DeliveryCity;
use common\models\DeliveryProvince;
use common\models\DeliveryFee;
use common\components\ErrorGenerateComponent;
use admin\components\DeliveryCostComponent;
use admin\models\DeliveryFeeSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{

  public function actionIndex()
  {
        BaseController::$page_caption = 'Delivery Fee';

        $searchModel = new DeliveryFeeSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $provinceId = '';
        if(isset($_POST['province_id'])){
            $provinceId = $_POST['province_id'];
            $noProblem = true;
            $trans = Yii::$app->db->beginTransaction();

            $count = 0;
            $defaultCity = DeliveryCity::find()->andWhere('city_id = :c_id', [':c_id' => 155])->one();
            if(empty($defaultCity)){
                Yii::$app->session->setFlash('danger', 'Default City not Found. Please, Synchronize the City first.');
                $noProblem = false;
            }

            $cities = DeliveryCity::find()->andWhere('province_id = :p_id', [':p_id' => $_POST['province_id']])->all();
            
            if($noProblem && count($cities) < 1){
                Yii::$app->session->setFlash('danger', 'Please, Synchronize the City first.');
                $noProblem = false;
            }

            if($noProblem){
                foreach ($cities as $i => $item) {
                    $fee = DeliveryCostComponent::getDeliveryFee($item->city_id, 1000);
                    $temp = DeliveryFee::find()->andWhere('origin_city_id = :o_id AND destination_city_id = :d_id', [':o_id' => $defaultCity->id, ':d_id' => $item->id])->one();
                    if(empty($temp)){
                        $temp = new DeliveryFee();
                    }
                    
                    $temp->origin_city_id = $defaultCity->id;
                    $temp->destination_city_id = $item->id;
                    $temp->fee_value = $fee;
                    if(!$temp->save()){
                        $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                        $noProblem = false;
                        Yii::$app->session->setFlash('danger', $errorMessage);
                        break;
                    }
                }
            }
            
            if ($noProblem) {
                $trans->commit();
                Yii::$app->session->setFlash('success', 'Synchronisation is successfully done. '.count($cities).' delivery fee is updated.');
            }
        }

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
            'provinceId' => $provinceId,
        ]);
  }

  public function actionSyncron()
  {
      // $data = DeliveryCostComponent::getDeliveryFee(444, 1000);
      // print_r($data);
      // exit();
      $noProblem = true;
      $trans = Yii::$app->db->beginTransaction();

      $count = 0;
      $defaultCity = DeliveryCity::find()->andWhere('city_id = :c_id', [':c_id' => 155])->one();
      if(empty($defaultCity)){
          Yii::$app->session->setFlash('danger', 'Default City not Found. Please, Synchronize the City first.');
          return $this->redirect(['index']);
      }

      $cities = DeliveryCity::find()->all();
      
      if(count($cities) < 1){
          Yii::$app->session->setFlash('danger', 'Please, Synchronize the City first.');
          return $this->redirect(['index']);
      }

      foreach ($cities as $i => $item) {
          $fee = DeliveryCostComponent::getDeliveryFee($item->city_id, 1000);
          $temp = DeliveryFee::find()->andWhere('origin_city_id = :o_id AND destination_city_id = :d_id', [':o_id' => $defaultCity->id, ':d_id' => $item->id])->one();
          if(empty($temp)){
              $temp = new DeliveryFee();
          }
          
          $temp->origin_city_id = $defaultCity->id;
          $temp->destination_city_id = $item->id;
          $temp->fee_value = $fee;
          if(!$temp->save()){
              $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
              $noProblem = false;
              Yii::$app->session->setFlash('danger', $errorMessage);
              break;
          }
      }
      
      if ($noProblem) {
          $trans->commit();
          Yii::$app->session->setFlash('success', 'Synchronisation is successfully done. '.count($cities).' delivery fee is downloaded.');
      }

      return $this->redirect(['index']);
  }

    public function actionDelete($id)
    {
      $model = $this->findModel($id);
      if($model->getIsDataUsed()){
          Yii::$app->session->setFlash('danger', 'cannot delete Delivery Fee, the data is used.');
      }
      else{
          $model->delete();
          Yii::$app->session->setFlash('success', 'Delivery Fee '.LabelComponent::SUCCESS_DELETE);
      }

      return $this->redirect(['index']);
    }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = DeliveryFee::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
