<?php

namespace admin\modules\deliveryfee\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\DeliveryProvince;
use common\components\ErrorGenerateComponent;
use admin\components\DeliveryCostComponent;
use admin\models\DeliveryProvinceSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class ProvinceController extends BaseController
{

  public function actionIndex()
	{
		  BaseController::$page_caption = 'Province';

		  $searchModel = new DeliveryProvinceSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
	}

  public function actionSyncron()
  {
      $data = json_decode(DeliveryCostComponent::getProvincesJSON());
      // print_r($data->rajaongkir->results);
      // exit();
      $noProblem = true;
      $trans = Yii::$app->db->beginTransaction();

      $count = 0;
      if ($data->rajaongkir->status->code == "200") {
          foreach($data->rajaongkir->results as $result) {

              $province = DeliveryProvince::find()->andWhere('province_id = :p_id', [':p_id' => $result->province_id])->one();
              if(empty($province)){
                  $temp = new DeliveryProvince();
                  $temp->province_id = $result->province_id;
                  $temp->province_name = $result->province;
                  if(!$temp->save()){
                      $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                      $noProblem = false;
                      Yii::$app->session->setFlash('danger', $errorMessage);
                      break;
                  }

                  $count++;
              }
          }
      }
      else{
          $noProblem = false;
          Yii::$app->session->setFlash('danger', 'error from server.');
      }

      if ($noProblem) {
          $trans->commit();
          if($count > 0)
            Yii::$app->session->setFlash('success', 'Synchronisation is successfully done. '.$count.' new provinces is downloaded.');
          else
            Yii::$app->session->setFlash('success', 'Nothing downloaded. The data provinces is complete.');
      }

      return $this->redirect(['index']);
  }

	public function actionDelete($id)
	{
      $model = $this->findModel($id);
      if($model->getIsDataUsed()){
          Yii::$app->session->setFlash('danger', 'cannot delete '.$model->province_name.' because is used.');
      }
      else{
          $model->delete();
          Yii::$app->session->setFlash('success', 'Province '.LabelComponent::SUCCESS_DELETE);
      }

      return $this->redirect(['index']);
	}

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = DeliveryProvince::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
