<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use yii\bootstrap\ActiveForm;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\DeliveryFee;
use common\models\DeliveryProvince;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
// $toolbar[] = ButtonComponent::getSyncButton();

BaseController::$toolbar = [];

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>

<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 col-8">
                            <label>Province</label>
                            <?=Html::dropDownList('province_id', !empty($provinceId) ? $provinceId : '', ArrayHelper::map(DeliveryProvince::find()->orderBy(['province_name' => SORT_ASC])->all(),'id','province_name' ), ['class' => 'form-control input-sm', 'prompt' => 'Pilih', 'id' => 'province-name'])?>
                        </div>
                        <div class="col-md-2 col-2">
                            <label>&nbsp;</label><br>
                            <button type="button" id="btn-sync" class="btn btn-sm btn-warning" style="padding: 0.4rem 0.75rem;"><i class="la la-refresh"></i> Synchronize</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>

<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    [
                                        'attribute' => 'origin_city',
                                        'value' => function($model) {
                                            return !empty($model->originCity->city_name) ? $model->originCity->city_name : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'dest_city',
                                        'value' => function($model) {
                                            return !empty($model->destinationCity->city_name) ? $model->destinationCity->city_name : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'dest_province',
                                        'value' => function($model) {
                                            return !empty($model->destinationCity->province->province_name) ? $model->destinationCity->province->province_name : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'fee_value',
                                        'value' => function($model) {
                                            return isset($model->fee_value) ? CurrencyComponent::formatMoney($model->fee_value) : '';
                                        },
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap;">{delete}</div>',
                                        'buttons'  => [
                                            'delete' => function ($url, $model) {
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<script type="text/javascript">

$(document).on('click', '#btn-sync', function(){
    if($('#province-name').val() != ''){
        $('#application_form').submit();
    }
    else{
        swal({ 
            title: 'please select province first.', 
            type: 'warning', 
            showCancelButton: false, 
            closeOnConfirm: true, 
            allowOutsideClick: false,
            dangerMode: true
        });
    }
    
});

$(document).ready(function(){

});

</script>