<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\DeliveryProvince;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getSyncButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    'province_name',
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap;">{delete}</div>',
                                        'buttons'  => [
                                            'delete' => function ($url, $model) {
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
