<?php

namespace admin\modules\member\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Member;
use common\models\Order;
use common\models\OrderDetail;
use common\models\DeliveryProvince;
use common\models\DeliveryCity;
use admin\components\DeliveryCostComponent;
use admin\models\MemberSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex()
	{
		  BaseController::$page_caption = 'Member';

		  $searchModel = new MemberSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
	}

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Member';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

	public function actionCreate()
	{
      BaseController::$page_caption = 'Add Member';

		  $model = new Member();

      if ($model->load(Yii::$app->request->post())) {
          $model->attributes = $_POST['Member'];
          $model->created_on = !empty($model->created_on) ? date('Y-m-d', strtotime($model->created_on)).' '.date('H:i:s') : NULL;
          $model->member_address = !empty($model->member_address) ? nl2br($model->member_address) : NULL;
          $model->member_email = !empty($model->member_email) ? preg_replace('/\s+/', '', $model->member_email) : NULL;
          $model->generateEmailVerificationToken();
          $model->setPassword($model->member_password);
          $model->member_is_verified = 1;

          if ($model->save()) {

              Yii::$app->session->setFlash('success', 'Member '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }

          $model->created_on = !empty($model->created_on) ? date('d-m-Y', strtotime($model->created_on)) : NULL;
          $model->member_address = !empty($model->member_address) ? strip_tags($model->member_address) : NULL;
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
      ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Member';

  		$model = $this->findModel($id);
      $minut = !empty($model->created_on) ? date('H:i:s', strtotime($model->created_on)) : '';
      $model->created_on = !empty($model->created_on) ? date('d-m-Y', strtotime($model->created_on)) : NULL;
      $model->member_address = !empty($model->member_address) ? strip_tags($model->member_address) : NULL;
      $password = $model->member_password;
      $model->member_password = NULL;

      if ($model->load(Yii::$app->request->post())) {
          $model->created_on = !empty($model->created_on) ? date('Y-m-d', strtotime($model->created_on)).' '.(!empty($minut) ? $minut : date('H:i:s')) : NULL;
          $model->member_address = !empty($model->member_address) ? nl2br($model->member_address) : NULL;
          $model->member_email = !empty($model->member_email) ? preg_replace('/\s+/', '', $model->member_email) : NULL;
          if(empty($model->member_password)){
              $model->member_password = $password;
          }
          else{
              $model->setPassword($model->member_password);
          }

          if ($model->save()) {
              Yii::$app->session->setFlash('success', 'Member '.LabelComponent::SUCCESS_UPDATE);
              return $this->redirect(['index']);
          }

          $model->created_on = !empty($model->created_on) ? date('d-m-Y', strtotime($model->created_on)) : NULL;
          $model->member_address = !empty($model->member_address) ? strip_tags($model->member_address) : NULL;
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'update',
      ]);
	}

	public function actionDelete($id)
	{
      $model = $this->findModel($id);
      $model->is_deleted = 1;
      $model->save();

      Yii::$app->session->setFlash('success', 'Member '.LabelComponent::SUCCESS_DELETE);

      return $this->redirect(['index']);
	}

  public function actionGetcities()
  {
      $cities = DeliveryCity::find()->andWhere('province_id = :p_id', [':p_id' => $_POST['province_id']])->orderBy(['city_name' => SORT_ASC])->all();
      $arr = array();
      foreach ($cities as $i => $item) {
          $arr[$item->id] = $item->city_name;
      }

      return json_encode($arr);    
      // return json_encode(DeliveryCostComponent::getCities($_POST['province_id']));
  }

  public function actionGetorderdetail()
  {
      $order = Order::find()->andWhere('id = :id', [':id' => $_POST['id']])->one();
      
      $arr = array();
      foreach ($order->orderDetails as $i => $item) {
          $arr[] = [
              'product_name' => $item->product->product_name,
              'attribute' => $item->getAttributeOrder(),
              'detail_qty' => $item->detail_qty,
              'detail_price' => $item->detail_price,
              'detail_subtotal' => $item->detail_subtotal,
          ];
      }
      
      return json_encode($arr);
  }

    public function actionUpdateprovince()
    {
        $model = Member::find()->all();
        foreach ($model as $item) {
            if(!empty($item->province_id)){
                $province = DeliveryProvince::find()->andWhere('province_id = :p_id', [':p_id' => $item->province_id])->one();
                $city = DeliveryCity::find()->andWhere('city_id = :c_id', [':c_id' => $item->city_id])->one();

                $member = $this->findModel($item->id);
                $member->province_id = $province->id;
                $member->city_id = $city->id;
                $member->save();
            }
        }
    }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Member::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
