<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Member;
use common\models\DeliveryProvince;
use common\models\DeliveryCity;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/member/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Account</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'member_email')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'member_password')->passwordInput(['class'=>'form-control input-sm']) ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="row">
    <div class="col-6">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Detail</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'member_fullname')->textInput(['class'=>'form-control input-sm']) ?>
                    <?php if($mode == 'update'): ?>
                    <?= $form->field($model, 'member_is_verified')
                        ->dropDownList([0 => 'Not Yet', 1 => 'Yes'], ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                    <?php endif; ?>
                    <?= $form->field($model, 'member_status')
                        ->dropDownList($model->getStatusLabels(), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                    <?= $form->field($model, 'created_on')->textInput(['class'=>'form-control input-sm datepicker']) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Contacts</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'member_address')->textArea(['rows' => 4, 'class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'province_id')
                        ->dropDownList(ArrayHelper::map(DeliveryProvince::find()->orderBy(['province_name' => SORT_ASC])->all(),'id','province_name' ), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                    <input type="hidden" id="member-province_name" class="form-control" name="Member[province_name]" value="<?=!empty($model->province_name) ? $model->province_name : ''?>">
                    <?= $form->field($model, 'city_id')
                        ->dropDownList(empty($model->province_id) ? [] : ArrayHelper::map(DeliveryCity::find()->andWhere('province_id = :p_id', [':p_id' => $model->province_id])->orderBy(['city_name' => SORT_ASC])->all(),'id','city_name' ), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                    <input type="hidden" id="member-city_name" class="form-control" name="Member[city_name]" value="<?=!empty($model->city_name) ? $model->city_name : ''?>">
                    <?= $form->field($model, 'member_phone')->textInput(['class'=>'form-control input-sm']) ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>
<script type="text/javascript">
$(document).ready(function(){
    $("#member-province_id").change(function(e){
        e.preventDefault();
        var baseUrl = $('#baseUrl').val();
        var provinceId = $(this).val();

        $("#member-city_id option").remove();

        if (provinceId != "") {
            $("#member-province_name").val($("#member-province_id option:selected").text());
            $.post(baseUrl+'/getcities', {'province_id': provinceId}, function(response){
                $.each(response, function(k, v){
                    $("#member-city_id").append("<option value='"+k+"'>"+v+"</option>");
                });
                $("#member-city_id").trigger("change");
            }, 'json');
        }
    });

    $("#member-city_id").change(function(e){
        e.preventDefault();

        var cityId = $(this).val();

        if (cityId != "") {
            $("#member-city_name").val($("#member-city_id option:selected").text());
        }
    });
});
</script>