<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Member;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    'member_email',
                                    'member_fullname',
                                    [
                                        'attribute' => 'member_address',
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            return !empty($model->member_address) ? $model->member_address : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'province_name',
                                        'label' => 'Province',
                                    ],
                                    [
                                        'attribute' => 'city_name',
                                        'label' => 'City',
                                    ],
                                    'member_phone',
                                    [
                                        'attribute' => 'member_is_verified',
                                        'value' => function($model) {
                                            return $model->member_is_verified == 0 ? 'Not Yet' : 'Yes';
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'member_is_verified', [0 => 'Not Yet', 1 => 'Yes'], ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
                                    [
                                        'attribute' => 'member_status',
                                        'value' => function($model) {
                                            return $model->getStatusLabels($model->member_status);
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'member_status', (new Member)->getStatusLabels(), ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
                                    [
                                        'attribute' => 'created_on',
                                        'label' => 'Join Date',
                                        'value' => function($model) {
                                            // return !empty($model->created_on) ? date('d-m-Y', strtotime($model->created_on)) : '';
                                            return !empty($model->created_on) ? DateComponent::getHumanizedDate($model->created_on) : '';
                                        },
                                        'filter' => Html::activeTextInput($searchModel, 'start_date', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date', ['class' => 'form-control datepicker'])
                                        // 'filter' => false,
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap;">{view}{update}{delete}</div>',
                                        'buttons'  => [
                                            'view' => function ($url, $model) {
                                                // if (AccessComponent::hasAccess(Yii::$app->controller->module->id, Yii::$app->controller->id, 'update')) {
                                                    $url = Url::to(['view', 'id' => $model->id]);
                                                    return Html::a('<span class="btn btn-outline-success btn-sm"><i class="la la-eye"></i></span> ', $url, ['title' => 'Update']);
                                                // }
                                                // return "";
                                            },
                                            'update' => function ($url, $model) {
                                                // if (AccessComponent::hasAccess(Yii::$app->controller->module->id, Yii::$app->controller->id, 'update')) {
                                                    $url = Url::to(['update', 'id' => $model->id]);
                                                    return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                                // }
                                                // return "";
                                            },
                                            'delete' => function ($url, $model) {
                                                // if (AccessComponent::hasAccess(Yii::$app->controller->module->id, Yii::$app->controller->id, 'delete')) {
                                                    $url = Url::to(['delete', 'id' => $model->id]);
                                                    return Html::a(
                                                        '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                        '#',
                                                        [
                                                            'title' => Yii::t('yii', 'Delete'),
                                                            'aria-label' => Yii::t('yii', 'Delete'),
                                                            'onclick' => "deleteclick('".$url."');"
                                                        ]
                                                    );
                                                // }
                                                // return "";
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
