<?php

namespace admin\modules\order\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Member;
use common\models\Voucher;
use common\models\Inventory;
use common\models\Order;
use common\models\OrderDetail;
use common\models\DeliveryProvince;
use common\models\DeliveryCity;
use common\components\CurrencyComponent;
use common\components\ErrorGenerateComponent;
use admin\components\DeliveryCostComponent;
use admin\models\MemberSearch;
use admin\models\InventorySearch;
use admin\models\ProductSearch;
use admin\models\OrderSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;
use kartik\mpdf\Pdf;


class DefaultController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

    public function actionIndex()
    {
        BaseController::$page_caption = 'Orders';

        $searchModel = new OrderSearch();
        $prevDate = new \DateTime("first day of last month");
        $searchModel->start_date = $prevDate->format('d-m-Y');
        $searchModel->end_date = date("t-m-Y");
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionView($id)
    {
        BaseController::$page_caption = 'View order';

        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $model
        ]);
    }

	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Order';
        date_default_timezone_set('Asia/Jakarta');
        $model = new Order();
        $model->order_code = $model->getLatestNumber('order_code');
        $model->order_date = date('d-m-Y');
        $model->order_shipping_fee = 0;
        $model->order_payment_method = Order::METHOD_BANKTRANSFER;
        $model->voucher_value_rupiah = 0;

        $items = array();

        $searchModelMember = new MemberSearch();
        $dataProviderMember = $searchModelMember->search(Yii::$app->request->queryParams);

        $searchModelInventory = new InventorySearch();
        $dataProviderInventory = $searchModelInventory->search(Yii::$app->request->queryParams);

        if ($model->load(Yii::$app->request->post())) {
            $noProblem = true;
            $items = $_POST['item'];
            $trans = Yii::$app->db->beginTransaction();

            $model->attributes = $_POST['Order'];
            $model->order_date = !empty($model->order_date) ? date('Y-m-d', strtotime($model->order_date)).' '.date('H:i:s') : NULL;
            $model->order_recipient_address = !empty($model->order_recipient_address) ? nl2br($model->order_recipient_address) : NULL;
            $model->order_recipient_email = !empty($model->order_recipient_email) ? preg_replace('/\s+/', '', $model->order_recipient_email) : NULL;
            $model->order_note = !empty($model->order_note) ? nl2br($model->order_note) : NULL;
          
            if($model->checkThisCode()){
                $model->order_code = $model->getLatestNumber('order_code');
            }

            if ($model->save()) {
                $noItem = true;
                foreach($items as $i => $item) {
                    if ($i !== "{index}" && !empty($item['product_id'])) {
                        $noItem = false;
                        $temp = new OrderDetail();
                        $temp->order_id = $model->id;
                        $temp->product_id = $item['product_id'];
                        $temp->product_attribute_group_id = !empty($item['product_attribute_group_id']) ? $item['product_attribute_group_id'] : NULL;
                        $temp->detail_qty = $item['detail_qty'];
                        $temp->detail_price = $item['detail_price'];
                        $temp->detail_subtotal = $item['detail_subtotal'];
                        if (!$temp->save()) {
                            $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                            $noProblem = false;
                            Yii::$app->session->setFlash('danger', $errorMessage);
                            break;
                        }

                        $update = (new Inventory)->updateStock($temp->product_id, (!empty($temp->product_attribute_group_id) ? $temp->product_attribute_group_id : NULL), $temp->detail_qty, Inventory::STOCK_TYPE_MINUS);
                        if ($update['status'] == false) {
                            Yii::$app->session->setFlash('danger', $update['message']);
                            $noProblem = false;
                            break;
                        }
                    }
                }

                if ($noItem) {
                    Yii::$app->session->setFlash('danger', 'Paling sedikit harus memilih 1 barang');
                    $noProblem = false;
                }
            }
            else{
                // $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                $noProblem = false;
                // Yii::$app->session->setFlash('danger', $errorMessage);
            }

            if($noProblem){
                if(!empty($model->voucher_id) && !empty($model->voucher->voucher_qty)){
                    $voucher = Voucher::find()->andWhere('id=:id', [':id' => $model->voucher_id])->one();
                    $voucher->voucher_qty_used = $voucher->voucher_qty_used +1;
                    if(!$voucher->save()){
                        $errorMessage = ErrorGenerateComponent::generateErrorLabels($voucher->getErrors());
                        $noProblem = false;
                        Yii::$app->session->setFlash('danger', $errorMessage);
                    }
                }
            }

            if ($noProblem) {
                $trans->commit();

                $model->sendEmailByStatus();

                Yii::$app->session->setFlash('success', 'Order '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }

            $trans->rollback();
            $model->order_date = !empty($model->order_date) ? date('d-m-Y', strtotime($model->order_date)) : NULL;
            $model->order_recipient_address = !empty($model->order_recipient_address) ? strip_tags($model->order_recipient_address) : NULL;
            $model->order_note = !empty($model->order_note) ? strip_tags($model->order_note) : NULL;
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
            'searchModelMember' => $searchModelMember,
            'dataProviderMember' => $dataProviderMember,
            'searchModelInventory' => $searchModelInventory,
            'dataProviderInventory' => $dataProviderInventory,
            'items' => $items,
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Order';
        date_default_timezone_set('Asia/Jakarta');
  		$model = $this->findModel($id);
        $minut = !empty($model->order_date) ? date('H:i:s', strtotime($model->order_date)) : '';
        $model->order_date = !empty($model->order_date) ? date('d-m-Y', strtotime($model->order_date)) : NULL;
        $model->order_recipient_address = !empty($model->order_recipient_address) ? strip_tags($model->order_recipient_address) : NULL;
        $model->order_note = !empty($model->order_note) ? strip_tags($model->order_note) : NULL;
        $model->old_status = $model->order_status;
        $model->order_shipping_fee = round($model->order_shipping_fee, 2);

        $model->voucher_code = !empty($model->voucher->voucher_code) ? $model->voucher->voucher_code : NULL;
        $voucherId = !empty($model->voucher_id) ? $model->voucher_id : NULL;
        $model->voucher_value_rupiah = empty($model->voucher_value_rupiah) ? 0 : $model->voucher_value_rupiah;

        $searchModelMember = new MemberSearch();
        $dataProviderMember = $searchModelMember->search(Yii::$app->request->queryParams);

        $searchModelInventory = new InventorySearch();
        $dataProviderInventory = $searchModelInventory->search(Yii::$app->request->queryParams);

        $items = array();

        foreach($model->orderDetails as $i => $item) {
          
            $items[$i] = [
                'product_id' => $item->product_id,
                'product_attribute_group_id' => !empty($item->product_attribute_group_id) ? $item->product_attribute_group_id : '',
                'product_name' => !empty($item->product_attribute_group_id) ? $item->product->product_name.' '.$item->getAttributeOrder() : $item->product->product_name,
                'detail_qty' => $item->detail_qty,
                'detail_price' => $item->detail_price,
                'detail_subtotal' => $item->detail_subtotal,
            ];
        }

        if(!empty($model->member_id)){
            $model->member_fullname = $model->member->member_fullname;
        }

        if ($model->load(Yii::$app->request->post())) {
            $noProblem = true;
            $items = $_POST['item'];
            $trans = Yii::$app->db->beginTransaction();

            $model->attributes = $_POST['Order'];
            $model->order_date = !empty($model->order_date) ? date('Y-m-d', strtotime($model->order_date)).' '.(!empty($minut) ? $minut : date('H:i:s')) : NULL;
            $model->order_recipient_address = !empty($model->order_recipient_address) ? nl2br($model->order_recipient_address) : NULL;
            $model->order_recipient_email = !empty($model->order_recipient_email) ? preg_replace('/\s+/', '', $model->order_recipient_email) : NULL;
            $model->order_note = !empty($model->order_note) ? nl2br($model->order_note) : NULL;
          

            if ($model->save()) {
                if($model->old_status != Order::STATUS_EXPIRED){
                    foreach($model->orderDetails as $item) {
                        $update = (new Inventory)->updateStock($item->product_id, (!empty($item->product_attribute_group_id) ? $item->product_attribute_group_id : NULL), $item->detail_qty, Inventory::STOCK_TYPE_PLUS);

                        if ($update['status'] == false) {
                            Yii::$app->session->setFlash('danger', $update['message']);
                            $noProblem = false;
                            break;
                        }
                    }
                }

                if($noProblem){
                    $noItem = true;
                    OrderDetail::deleteAll('order_id=:id', [':id' => $id]);
                    foreach($items as $i => $item) {
                        if ($i !== "{index}" && !empty($item['product_id'])) {
                            $noItem = false;
                            $temp = new OrderDetail();
                            $temp->order_id = $model->id;
                            $temp->product_id = $item['product_id'];
                            $temp->product_attribute_group_id = !empty($item['product_attribute_group_id']) ? $item['product_attribute_group_id'] : NULL;
                            $temp->detail_qty = $item['detail_qty'];
                            $temp->detail_price = $item['detail_price'];
                            $temp->detail_subtotal = $item['detail_subtotal'];
                            if (!$temp->save()) {
                                $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                                $noProblem = false;
                                Yii::$app->session->setFlash('danger', $errorMessage);
                                break;
                            }

                            if($model->order_status != Order::STATUS_EXPIRED){
                                $update = (new Inventory)->updateStock($temp->product_id, (!empty($temp->product_attribute_group_id) ? $temp->product_attribute_group_id : NULL), $temp->detail_qty, Inventory::STOCK_TYPE_MINUS);
                                if ($update['status'] == false) {
                                    Yii::$app->session->setFlash('danger', $update['message']);
                                    $noProblem = false;
                                    break;
                                }
                            }
                        }
                    }

                    if ($noItem) {
                        Yii::$app->session->setFlash('danger', 'Paling sedikit harus memilih 1 barang');
                        $noProblem = false;
                    }
                }
            }
            else{
                // $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                $noProblem = false;
                // Yii::$app->session->setFlash('danger', $errorMessage);
            }

            if($noProblem && !empty($voucherId)){
                $voucherBefore = Voucher::find()->andWhere('id=:id', [':id' => $voucherId])->one();
                if(!empty($voucherBefore->voucher_qty)){
                    $voucherBefore->voucher_qty_used = $voucherBefore->voucher_qty_used -1;
                    if(!$voucherBefore->save()){
                        $errorMessage = ErrorGenerateComponent::generateErrorLabels($voucherBefore->getErrors());
                        $noProblem = false;
                        Yii::$app->session->setFlash('danger', $errorMessage);
                    }
                }
            }

            if($noProblem){
                if(!empty($model->voucher_id) && !empty($model->voucher->voucher_qty)){
                    $voucher = Voucher::find()->andWhere('id=:id', [':id' => $model->voucher_id])->one();
                    $voucher->voucher_qty_used = $voucher->voucher_qty_used +1;
                    if(!$voucher->save()){
                        $errorMessage = ErrorGenerateComponent::generateErrorLabels($voucher->getErrors());
                        $noProblem = false;
                        Yii::$app->session->setFlash('danger', $errorMessage);
                    }
                }
            }

            if ($noProblem) {
                $trans->commit();

                $model->sendEmailByStatus();

                Yii::$app->session->setFlash('success', 'Order '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }

            $trans->rollback();
            $model->order_date = !empty($model->order_date) ? date('d-m-Y', strtotime($model->order_date)) : NULL;
            $model->order_recipient_address = !empty($model->order_recipient_address) ? strip_tags($model->order_recipient_address) : NULL;
            $model->order_note = !empty($model->order_note) ? strip_tags($model->order_note) : NULL;
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
            'searchModelMember' => $searchModelMember,
            'dataProviderMember' => $dataProviderMember,
            'searchModelInventory' => $searchModelInventory,
            'dataProviderInventory' => $dataProviderInventory,
            'items' => $items,
        ]);
	}

	public function actionDelete($id)
	{
        $model = $this->findModel($id);
        $trans = Yii::$app->db->beginTransaction();
        $noProblem = true;

        if($model->order_status != Order::STATUS_EXPIRED){
            foreach($model->orderDetails as $item) {
                $update = (new Inventory)->updateStock($item->product_id, (!empty($item->product_attribute_group_id) ? $item->product_attribute_group_id : NULL), $item->detail_qty, Inventory::STOCK_TYPE_PLUS);

                if ($update['status'] == false) {
                    Yii::$app->session->setFlash('danger', $update['message']);
                    $noProblem = false;
                    break;
                }
            }
        }

        if($noProblem){
            if(!empty($model->voucher_id) && !empty($model->voucher->voucher_qty)){
                $voucher = Voucher::find()->andWhere('id=:id', [':id' => $model->voucher_id])->one();
                $voucher->voucher_qty_used = $voucher->voucher_qty_used -1;
                if(!$voucher->save()){
                    $errorMessage = ErrorGenerateComponent::generateErrorLabels($voucher->getErrors());
                    $noProblem = false;
                    Yii::$app->session->setFlash('danger', $errorMessage);
                }
            }
        }

        if ($noProblem) {
            $model->is_deleted = "1";
            if (!$model->save()) {
                $errorString = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                Yii::$app->session->setFlash('danger', 'Gagal menghapus order karena kesalahan berikut: '.$errorString);
                $noProblem = false;
            }
            else
                Yii::$app->session->setFlash('success', 'Order '.LabelComponent::SUCCESS_DELETE);
        }

        if ($noProblem)
            $trans->commit();
        else
            $trans->rollBack();

        return $this->redirect(['index']);
	}

    public function actionGetinventory()
    {
        $inventory = Inventory::find()->andWhere('id = :id', [':id' => $_POST['id']])->one();
      
        $arr = array(
            'product_id' => $inventory->product_id,
            'product_attribute_group_id' => !empty($inventory->product_attribute_group_id) ? $inventory->product_attribute_group_id : '',
            'product_price' => !empty($inventory->product->product_sale_price) ? $inventory->product->product_sale_price : $inventory->product->product_price,
            'product_name' => !empty($inventory->product_attribute_group_id) ? $inventory->product->product_name.' '.$inventory->attributeProduct : $inventory->product->product_name,
        );
      
        return json_encode($arr);
    }

    public function actionGetcities()
    {
        $cities = DeliveryCity::find()->andWhere('province_id = :p_id', [':p_id' => $_POST['province_id']])->orderBy(['city_name' => SORT_ASC])->all();
        $arr = array();
        foreach ($cities as $i => $item) {
            $arr[$item->id] = $item->city_name;
        }

        return json_encode($arr);    
        // return json_encode(DeliveryCostComponent::getCities($_POST['province_id']));
    }

    public function actionPrintreceipt($id)
    {
        $order = $this->findModel($id);

        $content = $this->renderPartial('_receipt', [
            'order' => $order
        ]);
        
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE, 
            'format' => Pdf::FORMAT_A4,
            'orientation' => Pdf::ORIENT_PORTRAIT, 
            'destination' => Pdf::DEST_BROWSER, 
            'filename' => 'Receipt - '.$order->order_receipt_number,
            'marginTop' => 0,
            'marginBottom' => 0,
            'marginLeft' => 0,
            'marginRight' => 0,
            'content' => $content,
            'cssInline' => '
                body {font-size: 11px;}
                hr {margin-top: 5px; margin-bottom: 5px;}
                .table-item {width: 100%;}
                .item-product {width: 70%; vertical-align: top;}
                .item-qty {width: 30%; vertical-align: top;}
                .row-sender-receiver td {font-size: 13px; vertical-align: top;}
            ',
        ]);
        
        return $pdf->render(); 
    }

    public function actionUpdateprovince()
    {
        $model = Order::find()->all();
        foreach ($model as $item) {
            if(!empty($item->order_recipient_province_id)){
                $province = DeliveryProvince::find()->andWhere('province_id = :p_id', [':p_id' => $item->order_recipient_province_id])->one();
                $city = DeliveryCity::find()->andWhere('city_id = :c_id', [':c_id' => $item->order_recipient_city_id])->one();

                $order = $this->findModel($item->id);
                $order->order_recipient_province_id = $province->id;
                $order->order_recipient_city_id = $city->id;
                $order->save();
            }
        }
    }

    public function actionUpdatestockexpired()
    {
        $model = Order::find()->andWhere('order_status = :status AND is_deleted = :is', [':is' => 0, ':status' => Order::STATUS_EXPIRED])->all();
        foreach ($model as $item) {
            $update = $item->sendStockBack();
            if($update['status'] == false){
                print_r($update['message']);
                exit();
            }
        }
    }

    public function actionExportexcel()
    {
        $searchModel = new OrderSearch();
        $prevDate = new \DateTime("first day of last month");
        $searchModel->start_date = $prevDate->format('d-m-Y');
        $searchModel->end_date = date("t-m-Y");
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams, false);
        // print_r(Yii::$app->request->queryParams);
        // exit();
        $arr = array();
        if(!empty(Yii::$app->request->queryParams)){
            $arr = Yii::$app->request->queryParams['OrderSearch'];
        }
        else{
            $arr['start_date'] = $searchModel->start_date;
            $arr['end_date'] = $searchModel->end_date;
        }

        OrderSearch::getExcel($dataProvider->models, $arr);
        
        return $this->redirect(['index']);
    }

    public function actionGetvoucher()
    {
        $voucher = Voucher::find()->andWhere('voucher_code = :code', [':code' => $_POST['code']])->one();
        $date = !empty($_POST['date']) ? date('Y-m-d H:i:s', strtotime($_POST['date'].' '.date('H:i').':00')) : '';
        $subtotal = isset($_POST['subtotal']) ? $_POST['subtotal'] : 0;

        $arr = ['status' => 'error', 'message' => 'Voucher Code is Not valid.'];

        if($voucher && !empty($date)){
            $noProblem = true;
            if(!empty($voucher->voucher_from) && empty($voucher->voucher_to)){
                if($date < $voucher->voucher_from){
                    $arr = ['status' => 'error', 'message' => 'Voucher Code is Expired.'];
                    $noProblem = false;
                }
            }

            if(empty($voucher->voucher_from) && !empty($voucher->voucher_to)){
                if($date > $voucher->voucher_to){
                    $arr = ['status' => 'error', 'message' => 'Voucher Code is Expired.'];
                    $noProblem = false;
                }
            }    

            if(!empty($voucher->voucher_from) && !empty($voucher->voucher_to)){
                if($date < $voucher->voucher_from || $date > $voucher->voucher_to){
                    $arr = ['status' => 'error', 'message' => 'Voucher Code is Expired.'];
                    $noProblem = false;
                }
            }

            if(!empty($voucher->voucher_min_order)){
                if($subtotal < $voucher->voucher_min_order){
                    $arr = ['status' => 'error', 'message' => 'Voucher Code, minimum order must be '.CurrencyComponent::formatMoney($voucher->voucher_min_order).'.'];
                    $noProblem = false;
                }
            }

            if(!empty($voucher->voucher_qty)){
                if($voucher->voucher_qty_used >= $voucher->voucher_qty){
                    $arr = ['status' => 'error', 'message' => 'Voucher Code has run out.'];
                    $noProblem = false;
                }
            }

            if($noProblem){
                $arr['status'] = 'success';
                $arr['message'] = '';
                $value = $voucher->voucher_value;
                if($voucher->voucher_type == Voucher::TYPE_PERCENT){
                    if(!empty($voucher->voucher_value) && !empty($subtotal)){
                        $value = $voucher->voucher_value * $subtotal / 100;
                    }
                    else{
                        $value = 0;
                    }
                    
                }

                $arr['voucher_value'] = $value;
                $arr['voucher_id'] = $voucher->id;
            }

        }

        return json_encode($arr);
    }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Order::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
