<?php
use common\models\OrderDetail;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\widgets\Pjax;
use frontend\components\LabelComponent;
use frontend\components\AccessComponent;
use common\components\CurrencyComponent;
use common\components\DateComponent;
?>
<div id="modal-member" class="modal fade text-left" tabindex="-1" role="dialog" aria-labelledby="myModalLabel16" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel16">Member</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <?php Pjax::begin(['id' => 'pjax-member', 'timeout' => 1000000]); ?>
                    <?=GridView::widget([
                        'id' => 'inventory-grid',
                        'dataProvider' => $dataProvider,
                        'filterModel' => $searchModel,
                        'tableOptions' => ['class' => 'table table-striped table-bordered table-hover'],
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            'member_email',
                            'member_fullname',
                            [
                                'attribute' => 'member_address',
                                'format' => 'raw',
                                'value' => function($model) {
                                    return !empty($model->member_address) ? $model->member_address : '';
                                },
                            ],
                            [
                                'attribute' => 'province_name',
                                'label' => 'Province',
                            ],
                            [
                                'attribute' => 'city_name',
                                'label' => 'City',
                            ],
                            'member_phone',
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'header'   => 'Actions',
                                'template' => '<div style="white-space: nowrap;">{add}</div>',
                                'buttons'  => [
                                    'add' => function ($url, $model) {
                                        return '<button type="button" data-dismiss="modal" class="btn btn-outline btn-add-member btn-outline-primary btn-sm " id="btn-add-'.$model->id.'" data-fullname="'.$model->member_fullname.'"><i class="la la-plus"></i></button>';
                                    },
                                ],
                            ],
                        ],
                    ]);?>
                <?php Pjax::end(); ?>  
                </div>
            </div>
        </div>
    </div>
</div>