<?php
use common\models\OrderDetail;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\widgets\Pjax;
use frontend\components\LabelComponent;
use frontend\components\AccessComponent;
use common\components\CurrencyComponent;
use common\components\DateComponent;
?>
<div id="modal-product" class="modal fade text-left" tabindex="-1" role="dialog" aria-labelledby="myModalLabel16" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel16">Product</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <?php Pjax::begin(['id' => 'pjax-product', 'timeout' => 1000000]); ?>
                    <?=GridView::widget([
                        'id' => 'inventory-grid',
                        'dataProvider' => $dataProvider,
                        'filterModel' => $searchModel,
                        'tableOptions' => ['class' => 'table table-striped table-bordered table-hover'],
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            [
                                'attribute' => 'product_name',
                                'value' => function($model) {
                                    return $model->product->product_name;
                                },
                            ],
                            [
                                'attribute' => 'attribute',
                                'label' => 'Attribute',
                                'format' => 'raw',
                                'value' => function($model) {
                                    return $model->attributeProduct;
                                },
                            ],
                            [
                                'attribute' => 'product_price',
                                'value' => function($model){
                                    return CurrencyComponent::formatMoney($model->product->product_price);
                                },
                                'filter' => false,
                            ],
                            [
                                'attribute' => 'product_sale_price',
                                'value' => function($model){
                                    return !empty($model->product->product_sale_price) ? CurrencyComponent::formatMoney($model->product_sale_price) : '';
                                },
                                'filter' => false,
                            ],
                            [
                                'attribute' => 'inventory_stock',
                                'label' => 'Stock',
                            ],
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'header'   => 'Actions',
                                'template' => '<div style="white-space: nowrap;">{add}</div>',
                                'buttons'  => [
                                    'add' => function ($url, $model) {
                                        return '<button type="button" data-dismiss="modal" class="btn btn-outline btn-add-product btn-outline-primary btn-sm " id="btn-add-'.$model->id.'" data-fullname="'.$model->product_id.'" ><i class="la la-plus"></i></button>';
                                    },
                                ],
                            ],
                        ],
                    ]);?>
                <?php Pjax::end(); ?>  
                </div>
            </div>
        </div>
    </div>
</div>