<?php
use yii\helpers\Url;
use common\components\CurrencyComponent;
use common\models\Setting;
?>
<!DOCTYPE html>
<html>
<head>
</head>
<body>
<table style="width: 100%; border: 1px solid #000; padding: 5px;">
	<tr>
		<td style="width: 50%;"><img src="<?=Url::base(true)?>/img/logo.jpg" alt="" /></td>
		<td style="width: 50%; text-align: right; vertical-align: bottom">
			<b>Total Berat: <?=$order->getWeightTotal()?> Kg</b>
			<?php if (!empty($order->order_receipt_number)):?>
			<br/><b><?=$order->order_receipt_number?></b>
			<?php endif;?>
			<?php if (!empty($order->order_shipping_fee) && $order->order_shipping_fee > 0):?>
			<br/><b>Ongkir: <?=CurrencyComponent::formatMoney($order->order_shipping_fee)?></b>
			<?php endif;?>
		</td>
	</tr>
	<tr>
		<td colspan="2"><hr></td>
	</tr>
	<tr>
		<td colspan="2"><b>Nomor Pesanan: <?=$order->order_code?></b></td>
	</tr>
	<tr class="row-sender-receiver">
		<td>
			<b>PENGIRIM</b><br/>
			<?=Setting::getSettingValueByName('from_name')?><br/>
			<?=Setting::getSettingValueByName('whatsapp_number_label')?>
		</td>
		<td style="vertical-align: top">
			<b>PENERIMA</b><br/>
			<?=$order->order_recipient_fullname?><br/>
			<?=$order->order_recipient_address?><br/>
			<?=$order->order_recipient_phone?>
		</td>
	</tr>
	<tr>
		<td colspan="2"><hr></td>
	</tr>
	<tr>
		<td colspan="2">
			<table class="table-item">
				<tr>
					<th class="item-product">PRODUCT</th>
					<th class="item-qty">QUANTITY</th>
				</tr>
				<?php foreach($order->orderDetails as $item):?>
				<tr>
					<td>
						<?=$item->product->product_name?>
						<?php if (!empty($item->product_attribute_group_id)):?>
						<br/>
						<?php foreach($item->productAttributeGroup->productAttributes as $i => $productAttribute):?>
							<?=$productAttribute->attribute0->attribute_name?>: <?=!empty($productAttribute->product_attribute_value_int) ? $productAttribute->product_attribute_value_int : (!empty($productAttribute->product_attribute_value_float) ? $productAttribute->product_attribute_value_float : (!empty($productAttribute->product_attribute_value_string) ? $productAttribute->product_attribute_value_string : ""))?>
						<?php endforeach;?>
						<?php endif;?>
					</td>
					<td><?=$item->detail_qty?> pcs</td>
				</tr>
				<?php endforeach;?>
			</table>
		</td>
	</tr>
</table>
</body>
</html>