<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use common\components\CurrencyComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Member;
use common\models\Order;
use common\models\DeliveryProvince;
use common\models\DeliveryCity;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/order/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <label class="control-label"><?= $model->getAttributeLabel('member_id')?></label>
                            <div class="input-group mb-1">
                                <input type="hidden" id="order-member_id" name="Order[member_id]" class="form-control" value="<?= !empty($model->member_id) ? $model->member_id : ''?>">
                                <input type="text" id="order-member_fullname" name="Order[member_fullname]" class="form-control input-sm" aria-describedby="button-addon2"  value="<?= !empty($model->member_fullname) ? $model->member_fullname : ''?>" readonly="readonly" data-toggle="modal" data-target="#modal-member">
                                <div class="input-group-append">
                                    <button id="btn-search-customer" class="btn btn-primary btn-sm btn-search-modal" type="button" data-toggle="modal" data-target="#modal-member"><i class="la la-search"></i></button>
                                </div>
                            </div>
                            <?= $form->field($model, 'order_code')->textInput(['class'=>'form-control input-sm', 'readonly' => true]) ?>
                            <?= $form->field($model, 'order_date')->textInput(['class'=>'form-control input-sm datepicker']) ?>
                            <?= $form->field($model, 'order_recipient_fullname')->textInput(['class'=>'form-control input-sm']) ?>
                            <?= $form->field($model, 'order_recipient_address')->textArea(['rows'=> 4, 'class'=>'form-control input-sm']) ?>
                            <?= $form->field($model, 'order_note')->textArea(['rows'=> 4, 'class'=>'form-control input-sm']) ?>
                        </div>
                        <div class="col-lg-6">
                            <?= $form->field($model, 'order_recipient_province_id')
                                ->dropDownList(ArrayHelper::map(DeliveryProvince::find()->orderBy(['province_name' => SORT_ASC])->all(),'id','province_name' ), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                            ?>
                            <input type="hidden" id="order-order_recipient_province_name" class="form-control" name="Order[order_recipient_province_name]" value="<?=!empty($model->order_recipient_province_name) ? $model->order_recipient_province_name : ''?>">
                            <?= $form->field($model, 'order_recipient_city_id')
                                ->dropDownList(empty($model->order_recipient_province_id) ? [] : ArrayHelper::map(DeliveryCity::find()->andWhere('province_id = :p_id', [':p_id' => $model->order_recipient_province_id])->orderBy(['city_name' => SORT_ASC])->all(),'id','city_name' ), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                            ?>
                            <input type="hidden" id="order-order_recipient_city_name" class="form-control" name="Order[order_recipient_city_name]" value="<?=!empty($model->order_recipient_city_name) ? $model->order_recipient_city_name : ''?>">
                            <?= $form->field($model, 'order_recipient_phone')->textInput(['class'=>'form-control input-sm']) ?>
                            <?= $form->field($model, 'order_recipient_email')->textInput(['class'=>'form-control input-sm']) ?>
                            <?= $form->field($model, 'order_status')
                                ->dropDownList($model->getStatusLabels(), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                            ?>
                            <?= $form->field($model, 'order_receipt_number')->textInput(['class' => 'form-control input-sm']);?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6">
                        <h4 class="card-title">Product</h4>
                    </div>
                    <div class="col-lg-6">
                        <button type="button" class="btn btn-sm btn-outline-info round pull-right btn-search-inventory" data-toggle="modal" data-target="#modal-product"><i class="la la-plus-circle"></i></button>
                    </div>
                </div>    
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="row-template" style="display: none">
                        <table class="table-template">
                            <tr id="row-{index}" class="row-item detail-item">
                                <?=Html::hiddenInput('item[{index}][product_id]', '', array('class' => 'product-id'));?>
                                <?=Html::hiddenInput('item[{index}][product_attribute_group_id]', '', array('class' => 'product-attribute-group-id'));?>
                                <td>
                                    <span class="product-name-label"></span>
                                    <?=Html::hiddenInput('item[{index}][product_name]', '', array('class' => 'product-name'));?>
                                </td>
                                <td><?=Html::textInput('item[{index}][detail_qty]', '', array('class' => 'form-control detail-qty angka input-sm'));?></td>
                                <td class="text-right">
                                    <span class="detail-price-label"></span>
                                    <?=Html::hiddenInput('item[{index}][detail_price]', '', array('class' => 'detail-price'));?>
                                </td>
                                <td class="text-right">
                                    <strong><span class="detail-subtotal-label"></span></strong>
                                    <?=Html::hiddenInput('item[{index}][detail_subtotal]', '', ['class' => 'form-control detail-subtotal']);?>
                                </td>
                                <td><center><button href="javascript:;" type="button" class="btn btn-outline-danger btn-sm btn-remove"><i class="la la-trash"></i></button></center></td>
                            </tr>
                        </table>
                    </div>
                    <div class="table-responsive mt-1">
                        <table class="table table-striped table-bordered table-hover table-item">
                            <thead>
                                <tr>
                                    <th style="width: 30%;" class="text-center">Product</th>
                                    <th style="width: 15%;" class="text-center">Qty</th>
                                    <th style="width: 25%;" class="text-center">Price</th>
                                    <th style="width: 25%;" class="text-center">Subtotal</th>
                                    <th style="width: 5%;"></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if (!empty($items)):?>
                                <?php foreach($items as $i => $item):?>
                                    <?php if ($i !== "{index}"):?>
                            <tr id="row-<?=$i?>" class="row-item detail-item">
                                <?=Html::hiddenInput('item['.$i.'][product_id]', $item['product_id'], array('class' => 'product-id'));?>
                                <?=Html::hiddenInput('item['.$i.'][product_attribute_group_id]', $item['product_attribute_group_id'], array('class' => 'product-attribute-group-id'));?>
                                <td>
                                    <span class="product-name-label"><?= $item['product_name']?></span>
                                    <?=Html::hiddenInput('item['.$i.'][product_name]', $item['product_name'], array('class' => 'product-name'));?>
                                </td>
                                <td><?=Html::textInput('item['.$i.'][detail_qty]', $item['detail_qty'], array('class' => 'form-control detail-qty angka input-sm'));?></td>
                                <td class="text-right">
                                    <span class="detail-price-label"><?=CurrencyComponent::formatMoney($item['detail_price'])?></span>
                                    <?=Html::hiddenInput('item['.$i.'][detail_price]', $item['detail_price'], array('class' => 'detail-price'));?>
                                </td>
                                <td class="text-right">
                                    <strong><span class="detail-subtotal-label"><?=CurrencyComponent::formatMoney($item['detail_subtotal'])?></span></strong>
                                    <?=Html::hiddenInput('item['.$i.'][detail_subtotal]', $item['detail_subtotal'], ['class' => 'form-control detail-subtotal']);?>
                                </td>
                                <td><center><button href="javascript:;" type="button" class="btn btn-outline-danger btn-sm btn-remove"><i class="la la-trash"></i></button></center></td>
                            </tr>
                                    <?php endif;?>
                                <?php endforeach;?>
                            <?php endif;?>
                            </tbody>
                            <tfooter>
                            <tr class="row-footer-subtotal">
                                <td colspan="3" class="col-number text-right"><strong>SUBTOTAL</strong></td>
                                <td class="text-right">
                                    <strong><span class="order-subtotal-label"><?=empty($model->order_subtotal) ? CurrencyComponent::formatMoney(0) : CurrencyComponent::formatMoney($model->order_subtotal)?></span></strong>
                                    <?=$form->field($model, 'order_subtotal')->hiddenInput()->label(false)?>
                                </td>
                                <td></td>
                            </tr>
                            <tr class="row-footer-subtotal">
                                <td colspan="3" class="col-number text-right"><strong>SHIPPING FEE</strong></td>
                                <td class="text-right">
                                    <?=$form->field($model, 'order_shipping_fee')->textInput(['class' => 'form-control input-sm angka'])->label(false)?>
                                </td>
                                <td></td>
                            </tr>
                            <tr class="row-footer-voucher">
                                <td colspan="3" class="col-number text-right"><strong>VOUCHER CODE</strong></td>
                                <td class="text-right">
                                    <?=$form->field($model, 'voucher_code')->textInput(['class' => 'form-control input-sm'])->label(false)?>
                                    <span class="voucher-value-rupiah-label"><?=empty($model->voucher_value_rupiah) ? CurrencyComponent::formatMoney(0) : CurrencyComponent::formatMoney($model->voucher_value_rupiah)?></span>
                                </td>
                                <td>
                                    <?=$form->field($model, 'voucher_id')->hiddenInput(['class' => 'form-control input-sm'])->label(false)?>
                                    <?=$form->field($model, 'voucher_value_rupiah')->hiddenInput(['class' => 'form-control input-sm'])->label(false)?>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" class="col-number text-right"><strong>GRAND TOTAL</strong></td>
                                <td class="text-right">
                                    <strong><span class="order-grand-total-label"><?=empty($model->order_grand_total) ? CurrencyComponent::formatMoney(0) : CurrencyComponent::formatMoney($model->order_grand_total)?></span></strong>
                                    <?=$form->field($model, 'order_grand_total')->hiddenInput()->label(false)?>
                                </td>
                                <td></td>
                            </tr>
                            </tfooter>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Payment Method</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'order_payment_method')->radioList($model->getMethodLabels2(), ['class' => 'i-checks checkcox-payment'])->label(false);?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>
<?php echo Yii::$app->view->render('_member', ['searchModel' => $searchModelMember, 'dataProvider' => $dataProviderMember]); ?>
<?php echo Yii::$app->view->render('_product', ['searchModel' => $searchModelInventory, 'dataProvider' => $dataProviderInventory]); ?>
<script type="text/javascript">

function countItemSubtotal(tr)
{
    var qty = tr.find(".detail-qty").val();
    var price = tr.find(".detail-price").val();
    var subtotal = parseFloat(qty) * parseFloat(price);
    
    tr.find(".detail-subtotal-label").html("Rp"+number_format(subtotal, 0, ',', '.'));
    tr.find(".detail-subtotal").val(subtotal);
    $('#order-voucher_code').trigger("blur");
    countTotal();
}

function countSubTotal()
{
    var total = parseFloat(0);
    $(".detail-subtotal").each(function(){
        if ($(this).val() != "")
            total = parseFloat(total) + parseFloat($(this).val());
    });

    $(".order-subtotal-label").html("Rp"+number_format(total, 0, ',', '.'));
    $("#order-order_subtotal").val(total);
}

function countTotal()
{
    countSubTotal();

    var total = 0;
    var subtotal = $("#order-order_subtotal").val();
    var shipping = $("#order-order_shipping_fee").val();
    var voucher = $("#order-voucher_value_rupiah").val();
    
    total = parseFloat(subtotal) + parseFloat(shipping) - parseFloat(voucher);
    $(".order-grand-total-label").html("Rp"+number_format(total, 0, ',', '.'));
    $("#order-order_grand_total").val(total);
}

function addRow(response) 
{
    var index = 0;
    if (typeof $(".table-item .row-item").last().attr("id") != 'undefined')
        index = parseInt($(".table-item .row-item").last().attr("id").split("-")[1]) + 1;

    var clone = $(".table-template .row-item").clone().attr("id", "row-"+index);
    
    clone.html(function(i, oldTr) {return oldTr.replace(/\{index}/g, index);});

    clone.find(".product-id").val(response.product_id);
    clone.find(".product-attribute-group-id").val(response.product_attribute_group_id);
    clone.find(".product-name-label").html(response.product_name);
    clone.find(".product-name").val(response.product_name);
    clone.find(".detail-price-label").html("Rp"+number_format(response.product_price, 0, ',', '.'));
    clone.find(".detail-price").val(response.product_price);
    clone.find(".detail-qty").val(1);
    
    $(".table-item").append(clone);
    countItemSubtotal(clone);
}

$(document).on("click", ".btn-add-member", function(e){
    var id = $(this).attr('id').split('-')[2];
    var fullname = $(this).data('fullname');

    $('#order-member_id').val(id);
    $('#order-member_fullname').val(fullname);
    e.preventDefault();
});

$(document).on("click", ".btn-add-product", function(e){
    var id = $(this).attr('id').split('-')[2];
    var baseUrl = $('#baseUrl').val();

    $.post(baseUrl+'/getinventory', {'id': id}, function(response){
        addRow(response);       
    }, 'json');

    e.preventDefault();
});

$(document).on("change", ".detail-qty", function(e){
    var tr = $(this).closest('tr');
    if($(this).val() == ''){
        $(this).val(1);
    }
    countItemSubtotal(tr);
});

$(document).on("input", ".detail-qty", function(e){
    if($(this).val() != ''){
        var tr = $(this).closest('tr');
        countItemSubtotal(tr);
    }
});

$(document).on("change", "#order-order_shipping_fee", function(e){
    
    if($(this).val() == ''){
        $(this).val(0);
        $('#order-voucher_code').trigger("blur");
        countTotal();
    }
});

$(document).on("input", "#order-order_shipping_fee", function(e){
    
    if($(this).val() != ''){
        $('#order-voucher_code').trigger("blur");
        countTotal();
    }
});

$(document).on("click", ".btn-remove", function(e){
    var tr = $(this).closest('tr');
    tr.remove();
    $('#order-voucher_code').trigger("blur");
    countTotal();
});

function toggleVoucher()
{
    if($('#order-voucher_id').val() != ''){
        $(".voucher-value-rupiah-label").show();
    }
    else{
        $(".voucher-value-rupiah-label").hide();
    }
}

$(document).on("change", "#order-order_date", function(e){
    $('#order-voucher_code').trigger("blur");
});

$(document).on("blur", "#order-voucher_code", function(e){
    var code = $(this).val();
    var date = $('#order-order_date').val();
    var subtotal = parseFloat($('#order-order_subtotal').val()) + parseFloat($('#order-order_shipping_fee').val());
    var baseUrl = $('#baseUrl').val();

    $('#order-voucher_id').val('');
    $('#order-voucher_value_rupiah').val(0);
    $(".voucher-value-rupiah-label").html("Rp"+number_format(0, 0, ',', '.'));
    toggleVoucher();
    countTotal();

    if(code != ''){
        $.post(baseUrl+'/getvoucher', {'code': code, 'date':date, 'subtotal': subtotal }, function(response){
            if(response.status == 'error'){
                swal({ 
                    title: response.message, 
                    type: 'warning', 
                    showCancelButton: false, 
                    closeOnConfirm: true, 
                    allowOutsideClick: false,
                    dangerMode: true
                }, function(){
                    $('#order-voucher_code').val('');
                    countTotal();
                }, function(){
                    return false;
                });
            }
            else{
                $('#order-voucher_id').val(response.voucher_id);
                $('#order-voucher_value_rupiah').val(response.voucher_value);
                $(".voucher-value-rupiah-label").html("Rp"+number_format(response.voucher_value, 0, ',', '.'));
                toggleVoucher();
                countTotal();
            }

        }, 'json');
    }
});

$(document).on('pjax:complete', function(e) {
    $.pjax.defaults.timeout = 1000000;
    // $(".select2").select2();
    $('.datepicker').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY',
        clearButton: true,
        weekStart: 1,
        time: false
    });
});

$(document).ready(function(){
    $.pjax.defaults.timeout = 1000000;
    toggleVoucher();
    countTotal();

    $("#order-order_recipient_province_id").change(function(e){
        e.preventDefault();
        var baseUrl = $('#baseUrl').val();
        var provinceId = $(this).val();

        $("#order-order_recipient_city_id option").remove();

        if (provinceId != "") {
            $("#order-order_recipient_province_name").val($("#order-order_recipient_province_id option:selected").text());
            $.post(baseUrl+'/getcities', {'province_id': provinceId}, function(response){
                $.each(response, function(k, v){
                    $("#order-order_recipient_city_id").append("<option value='"+k+"'>"+v+"</option>");
                });
                $("#order-order_recipient_city_id").trigger("change");
            }, 'json');
        }
    });

    $("#order-order_recipient_city_id").change(function(e){
        e.preventDefault();

        var cityId = $(this).val();

        if (cityId != "") {
            $("#order-order_recipient_city_name").val($("#order-order_recipient_city_id option:selected").text());
        }
    });

    $('.checkcox-payment label').each(function(){
        $(this).addClass('mr-1');
    });
});

</script>