<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Order;
use admin\models\OrderSearch;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();
$toolbar[] = ButtonComponent::getExportExcel();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<input id="baseUrlctrl" type="hidden" value="<?=Url::base()?>/order/default">
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                                'showFooter' => true,
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    [
                                        'attribute' => 'member_fullname',
                                        'value' => function($model) {
                                            return !empty($model->member->member_fullname) ? $model->member->member_fullname : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'order_code',
                                        'value' => function($model) {
                                            return $model->order_code;
                                        },
                                    ],
                                    [
                                        'attribute' => 'order_date',
                                        'value' => function($model) {
                                            return DateComponent::getHumanizedDate($model->order_date);
                                        },
                                        'filter' => Html::activeTextInput($searchModel, 'start_date', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date', ['class' => 'form-control datepicker'])
                                    ],
                                    [
                                        'attribute' => 'sipto',
                                        'label' => 'Ship to',
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            return $model->sipto;
                                        },
                                    ],
                                    'order_recipient_phone',
                                    'order_recipient_email',
                                    [
                                        'attribute' => 'order_subtotal',
                                        'value' => function($model) {
                                            return CurrencyComponent::formatMoney($model->order_subtotal);
                                        },
                                        'filter' => false,
                                        'contentOptions' => ['class' => 'col-number'],
                                        'headerOptions' => ['class' => 'col-number'],
                                        'footerOptions' => ['class' => 'col-number'],
                                        'footer' => CurrencyComponent::formatMoney(OrderSearch::getTotal($dataProvider->models, 'order_subtotal')),
                                    ],
                                    [
                                        'attribute' => 'order_shipping_fee',
                                        'value' => function($model) {
                                            return CurrencyComponent::formatMoney($model->order_shipping_fee);
                                        },
                                        'filter' => false,
                                        'contentOptions' => ['class' => 'col-number'],
                                        'headerOptions' => ['class' => 'col-number'],
                                        'footerOptions' => ['class' => 'col-number'],
                                        'footer' => CurrencyComponent::formatMoney(OrderSearch::getTotal($dataProvider->models, 'order_shipping_fee')),
                                    ],
                                    [
                                        'attribute' => 'voucher_code',
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            $voucher = "";

                                            if(!empty($model->voucher->voucher_code)){
                                                $voucher = $model->voucher->voucher_code;
                                                if(!empty($model->voucher_value_rupiah)){
                                                    $voucher .= '<br>'.CurrencyComponent::formatMoney($model->voucher_value_rupiah);
                                                }
                                            }

                                            return $voucher;
                                        },
                                        'filter' => false,
                                    ],
                                    [
                                        'attribute' => 'order_grand_total',
                                        'value' => function($model) {
                                            return CurrencyComponent::formatMoney($model->order_grand_total);
                                        },
                                        'filter' => false,
                                        'contentOptions' => ['class' => 'col-number'],
                                        'headerOptions' => ['class' => 'col-number'],
                                        'footerOptions' => ['class' => 'col-number'],
                                        'footer' => CurrencyComponent::formatMoney(OrderSearch::getTotal($dataProvider->models, 'order_grand_total')),
                                    ],
                                    [
                                        'attribute' => 'order_payment_method',
                                        'format' => 'html',
                                        'value' => function($model) {
                                            return $model->getMethodLabels($model->order_payment_method);
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'order_payment_method', (new Order)->getMethodLabels2(), ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
                                    [
                                        'attribute' => 'order_status',
                                        'value' => function($model) {
                                            return $model->getStatusLabels($model->order_status);
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'order_status', (new Order)->getStatusLabels(), ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
                                    [
                                        'attribute' => 'order_note',
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            return !empty($model->order_note) ? $model->order_note : '';
                                        }
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap;">{update}{delete}</div><div style="white-space: nowrap;">{view}{print}</div>',
                                        'buttons'  => [
                                            'print' => function($url, $model) {
                                                $url = Url::to(['printreceipt', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-primary btn-sm"><i class="la la-print"></i></span> ', 
                                                    '#',
                                                    [
                                                        'title' => 'Print Receipt',
                                                        'aria-label' => 'Print Receipt',
                                                        'onclick' => "printreceiptclick('".$url."', '".$model->order_status."', '".$model->order_receipt_number."');"
                                                    ]
                                                );
                                            },
                                            'view' => function ($url, $model) {
                                                $url = Url::to(['view', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-success btn-sm"><i class="la la-eye"></i></span> ', $url, ['title' => 'View']);
                                            },
                                            'update' => function ($url, $model) {
                                                $url = Url::to(['update', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                            },
                                            'delete' => function ($url, $model) {
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<script type="text/javascript">
function printreceiptclick(url, status, receiptNumber)
{
    if (status != "<?=Order::STATUS_PAID?>" && status != "<?=Order::STATUS_SENT?>" && status != "<?=Order::STATUS_COMPLETED?>") {
        swal("Something's Wrong!", "This order's status must be set to PAID, SENT or COMPLETE!", "error");
    //} else if (receiptNumber == "") {
        //swal("Something's Wrong!", "This order's receipt number is still empty", "error");
    } else {
        window.open(url);
    }
}
// $(document).ready(function(){
//     $('#ordersearch-order_payment_method option').each(function(i){
        
//         var temp = $(this).html();
//         // alert($(this).html());
//         $(this).html(temp.replace('&lt;b&gt;', '<b>'));
//     });
// });

$(document).on("pjax:success", function(){
    const urlParams = new URLSearchParams(window.location.search);
    const myParam = urlParams.get('sort');
    var baseUrl = $('#baseUrlctrl').val();
    
    var urlexcel = baseUrl+'/exportexcel?'+urlParams;
    $("a#excel_btn").attr("href", urlexcel);
    

    $('.datepicker').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY',
        clearButton: true,
        weekStart: 1,
        time: false
    });
    
});

$(document).ready(function(){
    const urlParams = new URLSearchParams(window.location.search);
    const myParam = urlParams.get('sort');
    var baseUrl = $('#baseUrlctrl').val();
    
    var urlexcel = baseUrl+'/exportexcel?'+urlParams;
    $("a#excel_btn").attr("href", urlexcel);
});
</script>