<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use app\components\BaseController;
use common\models\Member;
use common\models\Order;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getUpdateButton($model->id);
    
BaseController::$toolbar = $toolbar;
    
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_id')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=isset($model->member->member_fullname) ? $model->member->member_fullname : ''?></div>
                            </div>  
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_code')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=isset($model->order_code) ? $model->order_code : '-'?></div>
                            </div>  
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_date')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_date) ? DateComponent::getHumanizedDate($model->order_date) : '-'?></div>
                            </div>  
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_recipient_fullname')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=isset($model->order_recipient_fullname) ? $model->order_recipient_fullname : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_recipient_address')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_recipient_address) ? $model->order_recipient_address : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_note')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_note) ? $model->order_note : '-'?></div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_recipient_province_name')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_recipient_province_name) ? $model->order_recipient_province_name : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_recipient_city_name')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_recipient_city_name) ? $model->order_recipient_city_name : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_recipient_phone')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_recipient_phone) ? $model->order_recipient_phone : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_recipient_email')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_recipient_email) ? $model->order_recipient_email : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_status')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_status) ? $model->getStatusLabels($model->order_status) : '-'?></div>
                            </div>
                            <div class="row mb-1">
                                <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_receipt_number')?></b></div>
                                <div class="col-lg-1">:</div>
                                <div class="col-lg-7"><?=!empty($model->order_receipt_number) ? $model->order_receipt_number : '-'?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Product</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover table-item">
                            <thead>
                            <tr>
                                <th style="width: 35%;" class="text-center">Product</th>
                                <th style="width: 15%;" class="text-center">Qty</th>
                                <th style="width: 25%;" class="text-center">Price</th>
                                <th style="width: 25%;" class="text-center">Subtotal</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach($model->orderDetails as $i => $item):?>
                            <tr>
                                <td><?= !empty($item->product_attribute_group_id) ? $item->product->product_name.' '.$item->getAttributeOrder() : $item->product->product_name?></td>
                                <td class="text-center"><?= $item->detail_qty?></td>
                                <td class="text-right"><?= CurrencyComponent::formatMoney($item->detail_price)?></td>
                                <td class="text-right"><?= CurrencyComponent::formatMoney($item->detail_subtotal)?></td>
                            </tr>
                            <?php endforeach;?>        
                            </tbody>
                            <tfooter>
                                <tr>
                                    <td colspan="3" class="text-right"><b>SUBTOTAL</b></td>
                                    <td class="text-right"><?=CurrencyComponent::formatMoney($model->order_subtotal)?></td>
                                </tr>
                                <tr>
                                    <td colspan="3" class="text-right"><b>SHIPPING FEE</b></td>
                                    <td class="text-right"><?=CurrencyComponent::formatMoney($model->order_shipping_fee)?></td>
                                </tr>
                                <?php 
                                    if(!empty($model->voucher->voucher_code)):
                                ?>
                                <tr>
                                    <td colspan="3" class="text-right"><b>VOUCHER CODE</b></td>
                                    <td class="text-right">
                                            <?=$model->voucher->voucher_code?>
                                            <br>
                                            <?=CurrencyComponent::formatMoney($model->order_shipping_fee)?>
                                    </td>
                                </tr>
                                <?php endif; ?>
                                <tr>
                                    <td colspan="3" class="text-right"><h4><b>GRAND TOTAL</b></h4></td>
                                    <td class="text-right"><h4><b><?=CurrencyComponent::formatMoney($model->order_grand_total)?></b></h4></td>
                                </tr>
                            </tfooter>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Payment Method</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?=$model->getMethodLabels2($model->order_payment_method)?>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
$(document).ready(function(){
    $(".btn-view-detail").click(function(e){
        var baseUrl = $('#baseUrl').val();
        id = $(this).attr('id').split('-')[2];
        
        $(".table-detail tbody .row-item").remove();
        $.post(baseUrl+'/getorderdetail', {'id': id}, function(response){
            $.each(response, function(k, v){
                var tr = '<tr class="row-item">'+
                                '<td>'+v.product_name+'</td>'+
                                '<td>'+v.attribute+'</td>'+
                                '<td>'+v.detail_qty+'</td>'+
                                '<td>'+v.detail_price+'</td>'+
                                '<td>'+v.detail_subtotal+'</td>'+
                            '</tr>';
                
                $(".table-detail tbody").append(tr);
            });
        }, 'json');
        
    });
});

</script>