<?php

namespace admin\modules\paymentconfirmation\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\PaymentConfirmation;
use common\models\Order;
use admin\components\DeliveryCostComponent;
use admin\models\PaymentConfirmationSearch;
use admin\models\OrderSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex()
	{
		  BaseController::$page_caption = 'Payment Confirmation';

		  $searchModel = new PaymentConfirmationSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
	}

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Payment Confirmation';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

	public function actionCreate()
	{
      BaseController::$page_caption = 'Add Payment Confirmation';

		  $model = new PaymentConfirmation();

      $searchModelOrder = new OrderSearch();
      $dataProviderOrder = $searchModelOrder->search(Yii::$app->request->queryParams);

      if ($model->load(Yii::$app->request->post())) {
          $model->attributes = $_POST['PaymentConfirmation'];
          
          $imagename         = uniqid(rand());
          $model->image     = UploadedFile::getInstance($model, 'image');
          if(!empty($model->image)){
              $model->confirmation_proof_filename   = $imagename.'.'.$model->image->extension;
          }

          if ($model->save()) {
              if(!empty($model->image)){
                $urlImage = str_replace('admin', '', Url::to('@app').'uploads/paymentconfirmations/'.$imagename.'.'.$model->image->extension);
                $model->image->saveAs($urlImage);
              }

              Yii::$app->session->setFlash('success', 'Payment Confirmation '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
         'searchModelOrder' => $searchModelOrder,
         'dataProviderOrder' => $dataProviderOrder,
      ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Payment Confirmation';

  		$model = $this->findModel($id);
      $searchModelOrder = new OrderSearch();
      $dataProviderOrder = $searchModelOrder->search(Yii::$app->request->queryParams);

      $model->order_code = $model->order->order_code;

      if ($model->load(Yii::$app->request->post())) {
          $imagename         = uniqid(rand());
          $model->image     = UploadedFile::getInstance($model, 'image');
          if(!empty($model->image)){
              $model->confirmation_proof_filename   = $imagename.'.'.$model->image->extension;
          }

          if ($model->save()) {
              if(!empty($model->image)){
                $urlImage = str_replace('admin', '', Url::to('@app').'uploads/paymentconfirmations/'.$imagename.'.'.$model->image->extension);
                $model->image->saveAs($urlImage);
              }

              Yii::$app->session->setFlash('success', 'Payment Confirmation '.LabelComponent::SUCCESS_UPDATE);
              return $this->redirect(['index']);
          }
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'update',
         'searchModelOrder' => $searchModelOrder,
         'dataProviderOrder' => $dataProviderOrder,
      ]);
	}

	public function actionDelete($id)
	{
      $model = $this->findModel($id);
      // $model->is_deleted = 1;
      $model->delete();

      Yii::$app->session->setFlash('success', 'Payment Confirmation '.LabelComponent::SUCCESS_DELETE);

      return $this->redirect(['index']);
	}

  public function actionStatus($id)
  {
      $model = $this->findModel($id);
      if($model->confirmation_status == PaymentConfirmation::STATUS_PENDING){
          $model->confirmation_status = PaymentConfirmation::STATUS_CONFIRMED;
      }
      else{
          $model->confirmation_status = PaymentConfirmation::STATUS_PENDING;
      }

      $model->save();
      

      Yii::$app->session->setFlash('success', 'Payment Confirmation '.LabelComponent::SUCCESS_UPDATE);

      return $this->redirect(['index']);
  }
    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PaymentConfirmation::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
