<?php
use common\models\OrderDetail;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\widgets\Pjax;
use frontend\components\LabelComponent;
use frontend\components\AccessComponent;
use common\components\CurrencyComponent;
use common\components\DateComponent;
?>
<div id="modal-order" class="modal fade text-left" tabindex="-1" role="dialog" aria-labelledby="myModalLabel16" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel16">Order</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                <?php Pjax::begin(['id' => 'pjax-order', 'timeout' => 1000000]); ?>
                    <?=GridView::widget([
                        'id' => 'inventory-grid',
                        'dataProvider' => $dataProvider,
                        'filterModel' => $searchModel,
                        'tableOptions' => ['class' => 'table table-striped table-bordered table-hover'],
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            [
                                'attribute' => 'member_fullname',
                                'value' => function($model) {
                                    return !empty($model->member->member_fullname) ? $model->member->member_fullname : '';
                                },
                            ],
                            [
                                'attribute' => 'order_code',
                                'value' => function($model) {
                                    return $model->order_code;
                                },
                            ],
                            [
                                'attribute' => 'order_date',
                                'value' => function($model) {
                                    return DateComponent::getHumanizedDate($model->order_date);
                                },
                                'filter' => Html::activeTextInput($searchModel, 'start_date', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date', ['class' => 'form-control datepicker'])
                            ],
                            [
                                'attribute' => 'sipto',
                                'label' => 'Ship to',
                                'format' => 'raw',
                                'value' => function($model) {
                                    return $model->sipto;
                                },
                            ],
                            'order_recipient_phone',
                            'order_recipient_email',
                            [
                                'attribute' => 'order_subtotal',
                                'value' => function($model) {
                                    return CurrencyComponent::formatMoney($model->order_subtotal);
                                },
                            ],
                            [
                                'attribute' => 'order_shipping_fee',
                                'value' => function($model) {
                                    return CurrencyComponent::formatMoney($model->order_shipping_fee);
                                },
                            ],
                            [
                                'attribute' => 'order_grand_total',
                                'value' => function($model) {
                                    return CurrencyComponent::formatMoney($model->order_grand_total);
                                },
                            ],
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'header'   => 'Actions',
                                'template' => '<div style="white-space: nowrap;">{add}</div>',
                                'buttons'  => [
                                    'add' => function ($url, $model) {
                                        return '<button type="button" data-dismiss="modal" class="btn btn-outline btn-add-order btn-outline-primary btn-sm " id="btn-add-'.$model->id.'" data-ordercode="'.$model->order_code.'"><i class="la la-plus"></i></button>';
                                    },
                                ],
                            ],
                        ],
                    ]);?>
                <?php Pjax::end(); ?>  
                </div>
            </div>
        </div>
    </div>
</div>