<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\PaymentConfirmation;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/paymentconfirmation/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <label class="control-label"><?= $model->getAttributeLabel('order_id')?></label>
                    <div class="input-group mb-1">
                        <input type="hidden" id="paymentconfirmation-order_id" name="PaymentConfirmation[order_id]" class="form-control" value="<?= !empty($model->order_id) ? $model->order_id : ''?>">
                        <input type="text" id="paymentconfirmation-order_code" name="PaymentConfirmation[order_code]" class="form-control input-sm" aria-describedby="button-addon2"  value="<?= !empty($model->order_code) ? $model->order_code : ''?>" readonly="readonly" data-toggle="modal" data-target="#modal-order">
                        <div class="input-group-append">
                            <button id="btn-search-customer" class="btn btn-primary btn-sm btn-search-modal" type="button" data-toggle="modal" data-target="#modal-order"><i class="la la-search"></i></button>
                        </div>
                    </div>
                    <?= $form->field($model, 'confirmation_amount')->textInput(['class'=>'form-control input-sm angka']) ?>
                    <?= $form->field($model, 'confirmation_date')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'confirmation_sender_name')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'confirmation_email')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'image')->fileInput(['class' => 'labelWidth']) ?>
                    <?php
                        if(!empty($model->confirmation_proof_filename)){
                            $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/paymentconfirmations/".$model->confirmation_proof_filename);
                            if(file_exists("../../uploads/paymentconfirmations/".$model->confirmation_proof_filename)){
                                echo Html::img($urlImage, ['height' => '200px'])."<br>";
                                echo "<i>Upload new Receipt to replace this one</i>";
                            }
                        }
                    ?>
                    <?= $form->field($model, 'confirmation_status')
                        ->dropDownList($model->getStatusLabels(), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>
<?php echo Yii::$app->view->render('_order', ['searchModel' => $searchModelOrder, 'dataProvider' => $dataProviderOrder]); ?>

<script type="text/javascript">

$(document).on("click", ".btn-add-order", function(e){
    var id = $(this).attr('id').split('-')[2];
    var orderCode = $(this).data('ordercode');

    $('#paymentconfirmation-order_id').val(id);
    $('#paymentconfirmation-order_code').val(orderCode);
    e.preventDefault();
});

$(document).on('pjax:complete', function(e) {
    $.pjax.defaults.timeout = 1000000;
    // $(".select2").select2();
    $('.datepicker').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY',
        clearButton: true,
        weekStart: 1,
        time: false
    });
});

$(document).ready(function(){
    $.pjax.defaults.timeout = 1000000;

});
</script>