<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\PaymentConfirmation;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    [
                                        'attribute' => 'order_code',
                                        'label' => 'Order Number',
                                        'value' => function($model) {
                                            return $model->order->order_code;
                                        },
                                    ],
                                    [
                                        'attribute' => 'order_date',
                                        'value' => function($model) {
                                            return DateComponent::getHumanizedDate($model->order->order_date);
                                        },
                                        'filter' => Html::activeTextInput($searchModel, 'start_date2', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date2', ['class' => 'form-control datepicker'])
                                    ],
                                    [
                                        'attribute' => 'confirmation_amount',
                                        'value' => function($model){
                                            return CurrencyComponent::formatMoney($model->confirmation_amount);
                                        }
                                    ],
                                    [
                                        'attribute' => 'confirmation_date',
                                        'value' => function($model) {
                                            return $model->confirmation_date;
                                        },
                                        // 'filter' => Html::activeTextInput($searchModel, 'start_date', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date', ['class' => 'form-control datepicker'])
                                    ],
                                    'confirmation_sender_name',
                                    'confirmation_email',
                                    [
                                        'attribute' => 'confirmation_status',
                                        'value' => function($model) {
                                            return $model->getStatusLabels($model->confirmation_status);
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'confirmation_status', (new PaymentConfirmation)->getStatusLabels(), ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap; margin-bottom: 5px;">{view}{update}</div><div style="white-space: nowrap;">{delete} {status}</div>',
                                        'buttons'  => [
                                            'status' => function ($url, $model) {
                                                $url = Url::to(['status', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-'.($model->confirmation_status == PaymentConfirmation::STATUS_PENDING ? "info" : "dark").' btn-sm"><i class="la la-thumbs-'.($model->confirmation_status == PaymentConfirmation::STATUS_PENDING ? "up" : "down").'"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Status'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "updateStatusPayment('".$url."');"
                                                    ]
                                                );
                                            },
                                            'view' => function ($url, $model) {
                                                $url = Url::to(['view', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-success btn-sm"><i class="la la-eye"></i></span> ', $url, ['title' => 'View']);
                                            },
                                            'update' => function ($url, $model) {
                                                $url = Url::to(['update', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                            },
                                            'delete' => function ($url, $model) {    
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
