<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use app\components\BaseController;
use common\models\Member;
use common\models\Order;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
    
BaseController::$toolbar = $toolbar;
    
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/member/default">
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Detail</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('order_id')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->order->order_code) ? $model->order->order_code : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('confirmation_amount')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->confirmation_amount) ? CurrencyComponent::formatMoney($model->confirmation_amount) : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('confirmation_date')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->confirmation_date) ? $model->confirmation_date : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('confirmation_sender_name')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->confirmation_sender_name) ? $model->confirmation_sender_name : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('confirmation_email')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->confirmation_email) ? $model->confirmation_email : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('confirmation_status')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->confirmation_status) ? $model->getStatusLabels($model->confirmation_status) : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b>Receipt</b></div>
                        <div class="col-lg-1"></div>
                        <div class="col-lg-7"></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-12">
                            <?php 
                                $image = '-';
                                if(!empty($model->confirmation_proof_filename)){
                                    $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/paymentconfirmations/".$model->confirmation_proof_filename);
                                    if(file_exists("../../uploads/paymentconfirmations/".$model->confirmation_proof_filename)){
                                        $image =  Html::img($urlImage, ['height' => '200px'])."<br>";
                                    }
                                }
                                echo $image;
                             ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>