<?php

namespace admin\modules\product\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Attribute;
use common\models\Product;
use common\models\Inventory;
use common\models\ProductAttributeGroup;
use common\models\ProductAttribute;
use admin\components\DeliveryCostComponent;
use common\components\ErrorGenerateComponent;
use admin\models\ProductSearch;
use admin\models\AttributeSearch;
use admin\models\ProductAttributeGroupSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class AttributegroupController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex($id)
    {
        BaseController::$page_caption = 'Product Attribute';

        $searchModel = new ProductAttributeGroupSearch();
        $searchModel->product_id = $id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
            'productId' => $id,
        ]);
    }

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Product Attribute';

      $model = $this->findModel($id);
      $modelInventory = Inventory::find()->andWhere('product_id = :p_id AND product_attribute_group_id = :a_id', [':p_id' => $model->product_id, ':a_id' => $id])->one();

      return $this->render('view', [
          'model' => $model,
          'modelInventory' => $modelInventory,
      ]);
  }

    public function actionCreate($id)
    {
      BaseController::$page_caption = 'Add Product Attribute';
      $model = new ProductAttributeGroup();
      $product = Product::find()->andWhere('id = :id', [':id' => $id])->one();

      $modelInventory = new Inventory();
      $modelInventory->inventory_stock = 1;

      $searchModel = new AttributeSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
      $items = array();

      if ($model->load(Yii::$app->request->post())) {
          $noProblem = true;
          $items = $_POST['item'];
          $trans = Yii::$app->db->beginTransaction();

          $model->attributes = $_POST['ProductAttributeGroup'];
          $model->product_id = $id;
          if(!empty($model->group_label_id)){
              $model->group_label_id = $model->getGroupLabelId($model->group_label_id);
          }
          else{
              $model->group_label_id = NULL;
          }

          if ($model->save()) {

              if(!isset($_POST['Inventory']['inventory_stock'])){
                  $noProblem = false;
                  Yii::$app->session->setFlash('danger', 'Stock is required.');
              }

              if($noProblem){
                  $modelInventory->inventory_stock = $_POST['Inventory']['inventory_stock'];
                  $modelInventory->product_id = $id;
                  $modelInventory->product_attribute_group_id = $model->id;
                  if (!$modelInventory->save()) {
                      $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelInventory->getErrors());
                      $noProblem = false;
                      Yii::$app->session->setFlash('danger', $errorMessage);
                  }
              }

              if($noProblem){
                  $noItem = true;
                  foreach($items as $i => $item) {
                      if ($i !== "{index}" && !empty($item['attribute_id'])) {
                          $noItem = false;

                          if(empty($item['attribute_value'])){
                              $noProblem = false;
                              Yii::$app->session->setFlash('danger', 'Atrribute Value is required.');
                              break;
                          }

                          $temp = new ProductAttribute();
                          $temp->product_attribute_group_id = $model->id;
                          $temp->attribute_id = $item['attribute_id'];
                          if($item['attribute_type'] == Attribute::TYPE_INT){
                              $temp->product_attribute_value_int = $item['attribute_value'];
                              $temp->product_attribute_value_float = NULL;
                              $temp->product_attribute_value_string = NULL;
                          }
                          elseif($item['attribute_type'] == Attribute::TYPE_FLOAT){
                              $temp->product_attribute_value_int = NULL;
                              $temp->product_attribute_value_float = $item['attribute_value'];
                              $temp->product_attribute_value_string = NULL;
                          }
                          elseif($item['attribute_type'] == Attribute::TYPE_STRING){
                              $temp->product_attribute_value_int = NULL;
                              $temp->product_attribute_value_float = NULL;
                              $temp->product_attribute_value_string = $item['attribute_value'];
                          }
                          
                          if (!$temp->save()) {
                              $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                              $noProblem = false;
                              Yii::$app->session->setFlash('danger', $errorMessage);
                              break;
                          }
                      }
                  }

                  if ($noItem) {
                      Yii::$app->session->setFlash('danger', 'Paling sedikit harus memilih 1 Attribute');
                      $noProblem = false;
                  }
              }
              
          }
          else{
              // $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
              $noProblem = false;
              // Yii::$app->session->setFlash('danger', $errorMessage);
          }

          if ($noProblem) {
              $trans->commit();
              Yii::$app->session->setFlash('success', 'Attribute '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index', 'id' => $model->product_id]);
          }

          $trans->rollback();
      }

      return $this->render('form', [
         'model' => $model,
         'modelInventory' => $modelInventory,
         'mode' => 'create',
         'product' => $product,
         'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
          'items' => $items,
      ]);
    }

    public function actionUpdate($id)
    {
        BaseController::$page_caption = 'Update Product Attribute';

        $model = $this->findModel($id);
        $product = Product::find()->andWhere('id = :id', [':id' => $model->product_id])->one();
        $model->group_label_id = !empty($model->group_label_id) ? $model->groupLabel->group_label : NULL;

        $modelInventory = Inventory::find()->andWhere('product_id = :p_id AND product_attribute_group_id = :a_id', [':p_id' => $model->product_id, ':a_id' => $id])->one();
        if(!$modelInventory){
            $modelInventory = new Inventory();
            // $modelInventory->inventory_stock = 1;
        }

        $searchModel = new AttributeSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $items = array();

        foreach($model->productAttributes as $i => $item) {
            
            $value = "";
            if($item->attribute0->attribute_type == Attribute::TYPE_INT){
                $value = $item->product_attribute_value_int;
            }
            if($item->attribute0->attribute_type == Attribute::TYPE_FLOAT){
                $value = $item->product_attribute_value_float;
            }
            if($item->attribute0->attribute_type == Attribute::TYPE_STRING){
                $value = $item->product_attribute_value_string;
            }

            $items[$i] = [
                'attribute_id' => $item->attribute_id,
                'attribute_name' => $item->attribute0->attribute_name,
                'attribute_type' => $item->attribute0->attribute_type,
                'attribute_value' => $value,
            ];
        }

        if ($model->load(Yii::$app->request->post())) {
            $noProblem = true;
            $items = $_POST['item'];
            $trans = Yii::$app->db->beginTransaction();

            if(!empty($model->group_label_id)){
                $model->group_label_id = $model->getGroupLabelId($model->group_label_id);
            }
            else{
                $model->group_label_id = NULL;
            }

            if ($model->save()) {

                if(!isset($_POST['Inventory']['inventory_stock'])){
                    $noProblem = false;
                    Yii::$app->session->setFlash('danger', 'Stock is required.');
                }

                if($noProblem){
                    $modelInventory->inventory_stock = $_POST['Inventory']['inventory_stock'];
                    $modelInventory->product_id = $model->product_id;
                    $modelInventory->product_attribute_group_id = $model->id;
                    if (!$modelInventory->save()) {
                        $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelInventory->getErrors());
                        $noProblem = false;
                        Yii::$app->session->setFlash('danger', $errorMessage);
                    }
                }

                if($noProblem){
                    $noItem = true;
                    ProductAttribute::deleteAll('product_attribute_group_id=:id', [':id' => $id]);
                    foreach($items as $i => $item) {
                        if ($i !== "{index}" && !empty($item['attribute_id'])) {
                            $noItem = false;

                            if(empty($item['attribute_value'])){
                                $noProblem = false;
                                Yii::$app->session->setFlash('danger', 'Atrribute Value is required.');
                                break;
                            }

                            $temp = new ProductAttribute();
                            $temp->product_attribute_group_id = $model->id;
                            $temp->attribute_id = $item['attribute_id'];
                            if($item['attribute_type'] == Attribute::TYPE_INT){
                                $temp->product_attribute_value_int = $item['attribute_value'];
                                $temp->product_attribute_value_float = NULL;
                                $temp->product_attribute_value_string = NULL;
                            }
                            elseif($item['attribute_type'] == Attribute::TYPE_FLOAT){
                                $temp->product_attribute_value_int = NULL;
                                $temp->product_attribute_value_float = $item['attribute_value'];
                                $temp->product_attribute_value_string = NULL;
                            }
                            elseif($item['attribute_type'] == Attribute::TYPE_STRING){
                                $temp->product_attribute_value_int = NULL;
                                $temp->product_attribute_value_float = NULL;
                                $temp->product_attribute_value_string = $item['attribute_value'];
                            }
                            
                            if (!$temp->save()) {
                                $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                                $noProblem = false;
                                Yii::$app->session->setFlash('danger', $errorMessage);
                                break;
                            }
                        }
                    }

                    if ($noItem) {
                        Yii::$app->session->setFlash('danger', 'Paling sedikit harus memilih 1 Attribute');
                        $noProblem = false;
                    }
                }
            }
            else{
                // $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                $noProblem = false;
                // Yii::$app->session->setFlash('danger', $errorMessage);
            }

            if ($noProblem) {
                $trans->commit();
                Yii::$app->session->setFlash('success', 'Attribute '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index', 'id' => $model->product_id]);
            }

            $trans->rollback();
        }

        return $this->render('form', [
            'model' => $model,
            'modelInventory' => $modelInventory,
            'mode' => 'update',
            'product' => $product,
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
            'items' => $items,
        ]);
    }

    public function actionDelete($id)
    {
        $noProblem = true;
        $trans = Yii::$app->db->beginTransaction();

        $model = $this->findModel($id);

        ProductAttribute::deleteAll('product_attribute_group_id=:id', [':id' => $id]);
        $productId = $model->product_id;

        $modelInventory = Inventory::find()->andWhere('product_id = :p_id AND product_attribute_group_id = :a_id', [':p_id' => $model->product_id, ':a_id' => $id])->one();
        if($modelInventory){
            if(!$modelInventory->delete()){
                $noProblem = false;
                $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelInventory->getErrors());
                Yii::$app->session->setFlash('danger', $errorMessage);
            }
        }
        
        if($noProblem){
            if(!$model->delete()){
                $noProblem = false;
                $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                Yii::$app->session->setFlash('danger', $errorMessage);
            }
        }

        if($noProblem){
            $trans->commit();
            Yii::$app->session->setFlash('success', 'Attribute '.LabelComponent::SUCCESS_DELETE);
        }
        else{
            $trans->rollback();
        }
        
        return $this->redirect(['index', 'id' => $productId]);
    }


    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductAttributeGroup::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
