<?php

namespace admin\modules\product\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Category;
use admin\components\DeliveryCostComponent;
use admin\models\CategorySearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class CategoryController extends BaseController
{

  public function actionIndex()
	{
		  BaseController::$page_caption = 'Categories';

		  $searchModel = new CategorySearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
	}

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Category';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

	public function actionCreate()
	{
      BaseController::$page_caption = 'Add Category';

		  $model = new Category();

      if ($model->load(Yii::$app->request->post())) {
          $model->attributes = $_POST['Category'];
          if(!empty($model->category_name)){
              if(empty($model->category_slug)){
                  $model->category_slug = $model->slugify($model->category_name);
              }
              else{
                  $model->category_slug = $model->slugify($model->category_slug);
              }
          }

          if ($model->save()) {

              Yii::$app->session->setFlash('success', 'Categories '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
      ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Category';

  		$model = $this->findModel($id);

      if ($model->load(Yii::$app->request->post())) {
          if(!empty($model->category_name)){
              if(empty($model->category_slug)){
                  $model->category_slug = $model->slugify($model->category_name);
              }
              else{
                  $model->category_slug = $model->slugify($model->category_slug);
              }
          }

          if ($model->save()) {
              Yii::$app->session->setFlash('success', 'Category '.LabelComponent::SUCCESS_UPDATE);
              return $this->redirect(['index']);
          }

      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'update',
      ]);
	}

	public function actionDelete($id)
	{
      $model = $this->findModel($id);
      $model->is_deleted = 1;
      $model->save();

      Yii::$app->session->setFlash('success', 'Category '.LabelComponent::SUCCESS_DELETE);

      return $this->redirect(['index']);
	}

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Category::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
