<?php

namespace admin\modules\product\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Product;
use common\models\ProductAttributeGroup;
use common\models\ProductAttribute;
use common\models\Inventory;
use admin\components\DeliveryCostComponent;
use admin\models\ProductSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use common\components\ErrorGenerateComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex()
	{
		  BaseController::$page_caption = 'Products';

		  $searchModel = new ProductSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
	}

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Product';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

	public function actionCreate()
	{
      BaseController::$page_caption = 'Add Product';

		  $model = new Product();

      if ($model->load(Yii::$app->request->post())) {
          $model->attributes = $_POST['Product'];

          if(!empty($model->product_name)){
              if(empty($model->product_slug)){
                  $model->product_slug = $model->slugify($model->product_name);
              }
              else{
                  $model->product_slug = $model->slugify($model->product_slug);
              }
          }

          if ($model->save()) {

              Yii::$app->session->setFlash('success', 'Product '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
      ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Product';

  		$model = $this->findModel($id);

      if ($model->load(Yii::$app->request->post())) {
          if(!empty($model->product_name)){
              if(empty($model->product_slug)){
                  $model->product_slug = $model->slugify($model->product_name);
              }
              else{
                  $model->product_slug = $model->slugify($model->product_slug);
              }
          }
          
          if ($model->save()) {
              Yii::$app->session->setFlash('success', 'Product '.LabelComponent::SUCCESS_UPDATE);
              return $this->redirect(['index']);
          }

      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'update',
      ]);
	}

	public function actionDelete($id)
	{
      $model = $this->findModel($id);
      $model->is_deleted = 1;
      $model->save();

      Yii::$app->session->setFlash('success', 'Product '.LabelComponent::SUCCESS_DELETE);

      return $this->redirect(['index']);
	}

  public function actionCopy($id)
  {
      BaseController::$page_caption = 'Duplicate Product';

      $model = new Product();
      $modelCopy = $this->findModel($id);

      $model->product_name = $modelCopy->product_name;
      $model->product_slug = $modelCopy->product_slug;
      $model->category_id = $modelCopy->category_id;
      $model->product_price = round($modelCopy->product_price);
      $model->product_sale_price = isset($modelCopy->product_sale_price) ? round($modelCopy->product_sale_price) : NULL;
      $model->product_desc = $modelCopy->product_desc;
      $model->product_weight_in_gram = $modelCopy->product_weight_in_gram;
      $model->product_status = $modelCopy->product_status;

      if ($model->load(Yii::$app->request->post())) {
          $model->attributes = $_POST['Product'];
          $noProblem = true;
          $trans = Yii::$app->db->beginTransaction();

          if(!empty($model->product_name)){
              if(empty($model->product_slug)){
                  $model->product_slug = $model->slugify($model->product_name);
              }
              else{
                  $model->product_slug = $model->slugify($model->product_slug);
              }
          }

          if ($model->save()) {

              foreach ($modelCopy->inventories as $item) {
                  $inventory = new Inventory;
                  $inventory->product_id = $model->id;
                  $inventory->inventory_stock = $item->inventory_stock;
                  
                  if(!empty($item->product_attribute_group_id)){
                      $group = new ProductAttributeGroup;
                      $group->product_id =  $model->id;
                      $group->group_label_id = !empty($item->productAttributeGroup->group_label_id) ? $item->productAttributeGroup->group_label_id : NULL;
                      $group->attribute_group_title = $item->productAttributeGroup->attribute_group_title;
                      if($group->save()){
                          $inventory->product_attribute_group_id = $group->id; 
                          foreach ($item->productAttributeGroup->productAttributes as $val) {
                              $attribute = new ProductAttribute;
                              $attribute->product_attribute_group_id = $group->id;
                              $attribute->attribute_id = $val->attribute_id;
                              $attribute->product_attribute_value_int = !empty($val->product_attribute_value_int) ? $val->product_attribute_value_int : NULL;
                              $attribute->product_attribute_value_float = !empty($val->product_attribute_value_float) ? $val->product_attribute_value_float : NULL;
                              $attribute->product_attribute_value_string = !empty($val->product_attribute_value_string) ? $val->product_attribute_value_string : NULL;
                              if(!$attribute->save()){
                                  $errorMessage = ErrorGenerateComponent::generateErrorLabels($attribute->getErrors());
                                  $noProblem = false;
                                  Yii::$app->session->setFlash('danger', $errorMessage);
                                  break;
                              }
                          }
                      }
                      else{
                          $errorMessage = ErrorGenerateComponent::generateErrorLabels($group->getErrors());
                          $noProblem = false;
                          Yii::$app->session->setFlash('danger', $errorMessage);
                          break;
                      }
                  }
                  else{
                      $inventory->product_attribute_group_id = NULL; 
                  }

                  if($inventory->save()){
                      
                  }
                  else{
                      $errorMessage = ErrorGenerateComponent::generateErrorLabels($inventory->getErrors());
                      $noProblem = false;
                      Yii::$app->session->setFlash('danger', $errorMessage);
                      break;
                  } 
              }
          }

          if ($noProblem) {
              $trans->commit();
              Yii::$app->session->setFlash('success', 'Product '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }

          $trans->rollback();
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
      ]);
  }


    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Product::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
