<?php

namespace admin\modules\product\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Attribute;
use common\models\Inventory;
use common\models\Product;
use common\models\ProductImage;
use common\models\ProductAttributeGroup;
use common\models\ProductAttribute;
use admin\components\DeliveryCostComponent;
use common\components\ErrorGenerateComponent;
use admin\models\ProductSearch;
use admin\models\ProductImageSearch;
use admin\models\AttributeSearch;
use admin\models\InventorySearch;
use admin\models\ProductAttributeGroupSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class ImageController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex($id)
    {
        BaseController::$page_caption = 'Image';

        $searchModel = new ProductImageSearch();
        $searchModel->product_id = $id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
            'productId' => $id,
        ]);
    }

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Image';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

    public function actionCreate($id)
    {
      BaseController::$page_caption = 'Add Image';
      $model = new ProductImage();
      $product = Product::find()->andWhere('id = :id', [':id' => $id])->one();


      if ($model->load(Yii::$app->request->post())) {
          $noProblem = true;
          $trans = Yii::$app->db->beginTransaction();

          $model->attributes = $_POST['ProductImage'];
          $model->product_id = $id;

          $imagename         = uniqid(rand());
          $model->image     = UploadedFile::getInstance($model, 'image');
          if(!empty($model->image)){
            $model->product_image_filename   = $imagename.'.'.$model->image->extension;
          }

          if ($model->save()) {
              if(!empty($model->image)){
                  $urlImage = str_replace('admin', '', Url::to('@app').'uploads/products/'.$imagename.'.'.$model->image->extension);
                  $model->image->saveAs($urlImage);
              }
          }
          else{
              // $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
              $noProblem = false;
              // Yii::$app->session->setFlash('danger', $errorMessage);
          }

          if ($noProblem) {
              $trans->commit();
              Yii::$app->session->setFlash('success', 'Image '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index', 'id' => $model->product_id]);
          }

          $trans->rollback();
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
         'product' => $product,
      ]);
    }

    public function actionUpdate($id)
    {
        BaseController::$page_caption = 'Update Image';

        $model = $this->findModel($id);
        $product = Product::find()->andWhere('id = :id', [':id' => $model->product_id])->one();

        if ($model->load(Yii::$app->request->post())) {
            $noProblem = true;
            $trans = Yii::$app->db->beginTransaction();

            $imagename         = uniqid(rand());
            $model->image     = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
              $model->product_image_filename   = $imagename.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/products/'.$imagename.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }
            }
            else{
                // $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                $noProblem = false;
                // Yii::$app->session->setFlash('danger', $errorMessage);
            }

            if ($noProblem) {
                $trans->commit();
                Yii::$app->session->setFlash('success', 'Image '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index', 'id' => $model->product_id]);
            }

            $trans->rollback();
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
            'product' => $product,
        ]);
    }

    public function actionDelete($id)
    {
        $noProblem = true;
        $trans = Yii::$app->db->beginTransaction();

        $model = $this->findModel($id);
        $productId = $model->product_id;
        
        if(!$model->delete()){
            $noProblem = false;
            $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
            Yii::$app->session->setFlash('danger', $errorMessage);
        }

        if($noProblem){
            $trans->commit();
            Yii::$app->session->setFlash('success', 'Image '.LabelComponent::SUCCESS_DELETE);
        }
        else{
            $trans->rollback();
        }
        
        return $this->redirect(['index', 'id' => $productId]);
    }


    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductImage::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
