<?php

namespace admin\modules\product\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Attribute;
use common\models\Inventory;
use common\models\Product;
use common\models\ProductAttributeGroup;
use common\models\ProductAttribute;
use admin\components\DeliveryCostComponent;
use common\components\ErrorGenerateComponent;
use admin\models\ProductSearch;
use admin\models\AttributeSearch;
use admin\models\InventorySearch;
use admin\models\ProductAttributeGroupSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class InventoryController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex($id)
    {
        BaseController::$page_caption = 'Inventory';

        $searchModel = new InventorySearch();
        $searchModel->product_id = $id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
            'productId' => $id,
        ]);
    }

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Inventory';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

    public function actionCreate($id)
    {
      BaseController::$page_caption = 'Add Inventory';
      $model = new Inventory();
      $product = Product::find()->andWhere('id = :id', [':id' => $id])->one();
      $isHasAttribute = false;

      $modelAttr = new ProductAttributeGroup();

      $searchModel = new AttributeSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      $items = array();
      if ($model->load(Yii::$app->request->post())) {
          $noProblem = true;
          $trans = Yii::$app->db->beginTransaction();

          $model->attributes = $_POST['Inventory'];
          $model->product_id = $id;
          $model->product_attribute_group_id = NULL;

          if(isset($_POST['is_attribute'])){
              $isHasAttribute = true;
              $items = $_POST['item'];
              $modelAttr->attributes = $_POST['ProductAttributeGroup'];
              $modelAttr->product_id = $id;
              if(!empty($modelAttr->group_label_id)){
                  $modelAttr->group_label_id = $modelAttr->getGroupLabelId($modelAttr->group_label_id);
              }
              else{
                  $modelAttr->group_label_id = NULL;
              }

              if ($modelAttr->save()) {    
                  $model->product_attribute_group_id = $modelAttr->id;
                  $noItem = true;
                  foreach($items as $i => $item) {
                      if ($i !== "{index}" && !empty($item['attribute_id'])) {
                          $noItem = false;

                          if(empty($item['attribute_value'])){
                              $noProblem = false;
                              Yii::$app->session->setFlash('danger', 'Atrribute Value is required.');
                              break;
                          }

                          $temp = new ProductAttribute();
                          $temp->product_attribute_group_id = $modelAttr->id;
                          $temp->attribute_id = $item['attribute_id'];
                          if($item['attribute_type'] == Attribute::TYPE_INT){
                              $temp->product_attribute_value_int = $item['attribute_value'];
                              $temp->product_attribute_value_float = NULL;
                              $temp->product_attribute_value_string = NULL;
                          }
                          elseif($item['attribute_type'] == Attribute::TYPE_FLOAT){
                              $temp->product_attribute_value_int = NULL;
                              $temp->product_attribute_value_float = $item['attribute_value'];
                              $temp->product_attribute_value_string = NULL;
                          }
                          elseif($item['attribute_type'] == Attribute::TYPE_STRING){
                              $temp->product_attribute_value_int = NULL;
                              $temp->product_attribute_value_float = NULL;
                              $temp->product_attribute_value_string = $item['attribute_value'];
                          }
                          
                          if (!$temp->save()) {
                              $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                              $noProblem = false;
                              Yii::$app->session->setFlash('danger', $errorMessage);
                              break;
                          }
                      }
                  }

                  if ($noItem) {
                      Yii::$app->session->setFlash('danger', 'Paling sedikit harus memilih 1 Attribute');
                      $noProblem = false;
                  }
              }
              else{
                  $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelAttr->getErrors());
                  $noProblem = false;
                  Yii::$app->session->setFlash('danger', $errorMessage);
              }
          }

          if ($noProblem) {
              if ($model->save()) {

              }
              else{
                  $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                  $noProblem = false;
                  Yii::$app->session->setFlash('danger', $errorMessage);
              }
          }
          

          if ($noProblem) {
              $trans->commit();
              Yii::$app->session->setFlash('success', 'Inventory '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index', 'id' => $model->product_id]);
          }

          $trans->rollback();
      }

      return $this->render('form', [
         'model' => $model,
         'modelAttr' => $modelAttr,
         'mode' => 'create',
         'product' => $product,
         'isHasAttribute' => $isHasAttribute,
         'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
          'items' => $items,
      ]);
    }

    public function actionUpdate($id)
    {
        BaseController::$page_caption = 'Update Inventory';

        $model = $this->findModel($id);
        $product = Product::find()->andWhere('id = :id', [':id' => $model->product_id])->one();
        $isHasAttribute = !empty($model->product_attribute_group_id) ? true : false;
        $items = array();

        if(!empty($model->product_attribute_group_id)){
            $modelAttr = ProductAttributeGroup::find()->andWhere('id=:id', [':id' => $model->product_attribute_group_id])->one();
            $modelAttr->group_label_id = !empty($modelAttr->group_label_id) ? $modelAttr->groupLabel->group_label : NULL;
            foreach($modelAttr->productAttributes as $i => $item) {
                
                $value = "";
                if($item->attribute0->attribute_type == Attribute::TYPE_INT){
                    $value = $item->product_attribute_value_int;
                }
                if($item->attribute0->attribute_type == Attribute::TYPE_FLOAT){
                    $value = $item->product_attribute_value_float;
                }
                if($item->attribute0->attribute_type == Attribute::TYPE_STRING){
                    $value = $item->product_attribute_value_string;
                }

                $items[$i] = [
                    'attribute_id' => $item->attribute_id,
                    'attribute_name' => $item->attribute0->attribute_name,
                    'attribute_type' => $item->attribute0->attribute_type,
                    'attribute_value' => $value,
                ];
            }
        }
        else{
            $modelAttr = new ProductAttributeGroup();
        }
        
        $searchModel = new AttributeSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if ($model->load(Yii::$app->request->post())) {
            $noProblem = true;
            $trans = Yii::$app->db->beginTransaction();
            $groupId = NULL;

            if(isset($_POST['is_attribute'])){
                $isHasAttribute = true;
                $items = $_POST['item'];
                $modelAttr->attributes = $_POST['ProductAttributeGroup'];
                $modelAttr->product_id = $model->product_id;
                if(!empty($modelAttr->group_label_id)){
                    $modelAttr->group_label_id = $modelAttr->getGroupLabelId($modelAttr->group_label_id);
                }
                else{
                    $modelAttr->group_label_id = NULL;
                }

                if ($modelAttr->save()) {    
                    $model->product_attribute_group_id = $modelAttr->id;
                    $noItem = true;
                    ProductAttribute::deleteAll('product_attribute_group_id=:id', [':id' => $modelAttr->id]);
                    foreach($items as $i => $item) {
                        if ($i !== "{index}" && !empty($item['attribute_id'])) {
                            $noItem = false;

                            if(empty($item['attribute_value'])){
                                $noProblem = false;
                                Yii::$app->session->setFlash('danger', 'Atrribute Value is required.');
                                break;
                            }

                            $temp = new ProductAttribute();
                            $temp->product_attribute_group_id = $modelAttr->id;
                            $temp->attribute_id = $item['attribute_id'];
                            if($item['attribute_type'] == Attribute::TYPE_INT){
                                $temp->product_attribute_value_int = $item['attribute_value'];
                                $temp->product_attribute_value_float = NULL;
                                $temp->product_attribute_value_string = NULL;
                            }
                            elseif($item['attribute_type'] == Attribute::TYPE_FLOAT){
                                $temp->product_attribute_value_int = NULL;
                                $temp->product_attribute_value_float = $item['attribute_value'];
                                $temp->product_attribute_value_string = NULL;
                            }
                            elseif($item['attribute_type'] == Attribute::TYPE_STRING){
                                $temp->product_attribute_value_int = NULL;
                                $temp->product_attribute_value_float = NULL;
                                $temp->product_attribute_value_string = $item['attribute_value'];
                            }
                            
                            if (!$temp->save()) {
                                $errorMessage = ErrorGenerateComponent::generateErrorLabels($temp->getErrors());
                                $noProblem = false;
                                Yii::$app->session->setFlash('danger', $errorMessage);
                                break;
                            }
                        }
                    }

                    if ($noItem) {
                        Yii::$app->session->setFlash('danger', 'Paling sedikit harus memilih 1 Attribute');
                        $noProblem = false;
                    }
                }
                else{
                    $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelAttr->getErrors());
                    $noProblem = false;
                    Yii::$app->session->setFlash('danger', $errorMessage);
                }
            }
            else{
                
                if(!empty($model->product_attribute_group_id)){
                    $groupId = $model->product_attribute_group_id;
                    $model->product_attribute_group_id = NULL;
                }
            }

            if ($noProblem) {
                if ($model->save()) {
                    if(!empty($groupId)){
                        
                        ProductAttribute::deleteAll('product_attribute_group_id=:id', [':id' => $modelAttr->id]);    
                        if(!$modelAttr->delete()){
                            $noProblem = false;
                            $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelAttr->getErrors());
                            Yii::$app->session->setFlash('danger', $errorMessage);
                        }
                        
                    }
                }
                else{
                    $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
                    $noProblem = false;
                    Yii::$app->session->setFlash('danger', $errorMessage);
                }
            }

            if ($noProblem) {
                $trans->commit();
                Yii::$app->session->setFlash('success', 'Inventory '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index', 'id' => $model->product_id]);
            }

            $trans->rollback();
        }

        return $this->render('form', [
            'model' => $model,
            'modelAttr' => $modelAttr,
            'mode' => 'update',
            'product' => $product,
            'isHasAttribute' => $isHasAttribute,
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
            'items' => $items,
        ]);
    }

    public function actionDelete($id)
    {
        $noProblem = true;
        $trans = Yii::$app->db->beginTransaction();

        $model = $this->findModel($id);
        $productId = $model->product_id;
        $groupId = !empty($model->product_attribute_group_id) ? $model->product_attribute_group_id : NULL;

        if(!$model->delete()){
            $noProblem = false;
            $errorMessage = ErrorGenerateComponent::generateErrorLabels($model->getErrors());
            Yii::$app->session->setFlash('danger', $errorMessage);
        }

        if(!empty($groupId) && $noProblem){
            ProductAttribute::deleteAll('product_attribute_group_id=:id', [':id' => $groupId]);
            $modelAttr = ProductAttributeGroup::find()->andWhere('id=:id', [':id' => $groupId])->one();
            if($modelAttr){
                if(!$modelAttr->delete()){
                    $noProblem = false;
                    $errorMessage = ErrorGenerateComponent::generateErrorLabels($modelAttr->getErrors());
                    Yii::$app->session->setFlash('danger', $errorMessage);
                }
            }
        }

        if($noProblem){
            $trans->commit();
            Yii::$app->session->setFlash('success', 'Inventory '.LabelComponent::SUCCESS_DELETE);
        }
        else{
            $trans->rollback();
        }
        
        return $this->redirect(['index', 'id' => $productId]);
    }


    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Inventory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
