<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Category;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/member/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <?= $form->field($model, 'category_name')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'category_slug')->textInput(['class'=>'form-control input-sm']) ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>
