<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Product;
use common\models\Category;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/product/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <?= $form->field($model, 'product_name')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'product_slug')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'category_id')
                        ->dropDownList(ArrayHelper::map(Category::find()->andWhere('is_deleted=:is', [':is' => 0])->all(),'id','category_name' ), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                    <?= $form->field($model, 'product_price')->textInput(['class'=>'form-control input-sm angka']) ?>
                    <?= $form->field($model, 'product_sale_price')->textInput(['class'=>'form-control input-sm angka']) ?>
                    <?= $form->field($model, 'product_desc')->textArea(['class'=>'form-control tinymce']) ?>
                    <?= $form->field($model, 'product_weight_in_gram')->textInput(['class'=>'form-control input-sm angka']) ?>
                    <?= $form->field($model, 'product_status')
                        ->dropDownList($model->getStatusLabel(), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>
