<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Product;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    'product_name',
                                    [
                                        'attribute' => 'category_name',
                                        'value' => function($model) {
                                            return !empty($model->category->category_name) ? $model->category->category_name : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'product_price',
                                        'value' => function($model) {
                                            return CurrencyComponent::formatMoney($model->product_price);
                                        },
                                    ],
                                    [
                                        'attribute' => 'product_sale_price',
                                        'value' => function($model) {
                                            return !empty($model->product_sale_price) ? CurrencyComponent::formatMoney($model->product_sale_price) : '';
                                        },
                                    ],
                                    [
                                        'attribute' => 'product_desc',
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            return $model->product_desc;
                                        },
                                    ],
                                    [
                                        'attribute' => 'product_weight_in_gram',
                                        'value' => function($model) {
                                            return $model->product_weight_in_gram;
                                        },
                                    ],
                                    [
                                        'attribute' => 'product_status',
                                        'value' => function($model) {
                                            return $model->getStatusLabel($model->product_status);
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'product_status', (new Product)->getStatusLabel(), ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap; margin-bottom: 5px;">{view}{update}{delete}</div><div style="white-space: nowrap;">{image}{inventory}{copy}</div>',
                                        'buttons'  => [
                                            'image' => function ($url, $model) {
                                                $url = Url::to(['image/index', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-secondary btn-sm"><i class="la la-image"></i></span> ', $url, ['title' => 'Image']);
                                            },
                                            'inventory' => function ($url, $model) {
                                                $url = Url::to(['inventory/index', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-info btn-sm"><i class="la la-building"></i></span> ', $url, ['title' => 'Inventory']);
                                            },
                                            'copy' => function ($url, $model) {
                                                $url = Url::to(['copy', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-dark btn-sm"><i class="la la-copy"></i></span> ', $url, ['title' => 'Duplicate']);
                                            },
                                            // 'attribute' => function ($url, $model) {
                                            //     $url = Url::to(['attributegroup/index', 'id' => $model->id]);
                                            //     return Html::a('<span class="btn btn-outline-dark btn-sm"><i class="la la-asterisk"></i></span> ', $url, ['title' => 'Attribute']);
                                            // },
                                            'view' => function ($url, $model) {
                                                $url = Url::to(['view', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-success btn-sm"><i class="la la-eye"></i></span> ', $url, ['title' => 'Update']);
                                            },
                                            'update' => function ($url, $model) {    
                                                $url = Url::to(['update', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                            },
                                            'delete' => function ($url, $model) {
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
