<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use app\components\BaseController;
use common\models\Product;
use common\models\Category;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
    
BaseController::$toolbar = $toolbar;
    
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/member/default">
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_name')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->product_name) ? $model->product_name : ''?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_slug')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->product_slug) ? $model->product_slug : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('catgeory_id')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->category->category_name) ? $model->category->category_name : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_price')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->product_price) ? CurrencyComponent::formatMoney($model->product_price) : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_sale_price')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->product_sale_price) ? CurrencyComponent::formatMoney($model->product_sale_price) : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_desc')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->product_desc) ? $model->product_desc : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_weight_in_gram')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->product_weight_in_gram) ? $model->product_weight_in_gram : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('product_status')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->product_status) ? $model->getStatusLabel($model->product_status) : '-'?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if(!empty($model->inventories)): ?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Inventory</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover table-item">
                            <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Attribute</th>
                                <th>Stock</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($model->inventories as $i => $item): ?>
                                <tr>
                                    <td><?=$item->product->product_name?></td>
                                    <td><?=$item->attributeProduct?></td>
                                    <td><?=$item->inventory_stock?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>