<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ProductAttributeGroup;
use common\models\Attribute;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackInnerButton('image', 'index', ['id' => $product->id]);
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/product/inventory">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Product : <?= $product->product_name?></h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'image')->fileInput(['class' => 'labelWidth']) ?>
                    <?php
                        if(!empty($model->product_image_filename)){
                            $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/products/".$model->product_image_filename);
                            if(file_exists("../../uploads/products/".$model->product_image_filename)){
                                echo Html::img($urlImage, ['height' => '200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
                    <?= $form->field($model, 'product_image_is_default')
                        ->dropDownList([0 => 'No', 1 => 'Yes'], ['class' => 'form-control input-sm']);
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>
