<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ProductAttributeGroup;
use common\models\Attribute;
use common\models\ProductAttributeGroupLabel;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackInnerButton('inventory', 'index', ['id' => $product->id]);
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/product/inventory">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Product : <?= $product->product_name?></h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'inventory_stock')->textInput(['class'=>'form-control input-sm angka']) ?>
                    <label>Attribute</label>
                    <?= Html::checkbox('is_attribute', '', ['class' => 'i-checks is-attibute', 'checked' => $isHasAttribute ? true : false ])?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="row section-attribute">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Attribute</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($modelAttr, 'attribute_group_title')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($modelAttr, 'group_label_id')
                        ->dropDownList(ArrayHelper::map(ProductAttributeGroupLabel::find()->andWhere('is_deleted=:is', [':is' => 0])->all(),'group_label','group_label' ), ['class' => 'selectize-select', 'prompt' => 'Pilih']);
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="row section-attribute">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6">
                        <h4 class="card-title">Detail</h4>
                    </div>
                    <div class="col-lg-6">
                        <button type="button" class="btn btn-sm btn-outline-info round pull-right btn-search-inventory" data-toggle="modal" data-target="#modal-attribute"><i class="la la-plus-circle"></i></button>
                    </div>
                </div>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="row-template" style="display: none">
                        <table class="table-template">
                            <tr id="row-{index}" class="row-item detail-item">
                                <?=Html::hiddenInput('item[{index}][attribute_id]', '', array('class' => 'attribute-id'));?>
                                <?=Html::hiddenInput('item[{index}][attribute_type]', '', array('class' => 'attribute-type'));?>
                                <td>
                                    <span class="attribute-name-label"></span>
                                    <?=Html::hiddenInput('item[{index}][attribute_name]', '', array('class' => 'attribute-name'));?>
                                </td>
                                <td><?=Html::textInput('item[{index}][attribute_value]', '', array('class' => 'form-control attribute-value input-sm'));?></td>
                                <td><center><button href="javascript:;" type="button" class="btn btn-outline-danger btn-sm btn-remove"><i class="la la-trash"></i></button></center></td>
                            </tr>
                        </table>
                    </div>
                    <div class="table-responsive mt-1">
                        <table class="table table-striped table-bordered table-hover table-item">
                            <thead>
                                <tr>
                                    <th style="width: 50%;" class="text-center">Attribute</th>
                                    <th style="width: 45%;" class="text-center">Value</th>
                                    <th style="width: 5%;"></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if (!empty($items)):?>
                                <?php foreach($items as $i => $item):?>
                                    <?php if ($i !== "{index}"):?>
                            <tr id="row-<?=$i?>" class="row-item detail-item">
                                <?=Html::hiddenInput('item['.$i.'][attribute_id]', $item['attribute_id'], array('class' => 'attribute-id'));?>
                                <?=Html::hiddenInput('item['.$i.'][attribute_type]', $item['attribute_type'], array('class' => 'attribute-type'));?>
                                <td>
                                    <span class="attribute-name-label"><?=$item['attribute_name']?></span>
                                    <?=Html::hiddenInput('item['.$i.'][attribute_name]', $item['attribute_name'], array('class' => 'attribute-name'));?>
                                </td>
                                <td><?=Html::textInput('item['.$i.'][attribute_value]', $item['attribute_value'], array('class' => 'form-control attribute-value input-sm'));?></td>
                                <td><center><button href="javascript:;" type="button" class="btn btn-outline-danger btn-sm btn-remove"><i class="la la-trash"></i></button></center></td>
                            </tr>
                                    <?php endif;?>
                                <?php endforeach;?>
                            <?php endif;?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>
<?php echo Yii::$app->view->render('_attribute', ['searchModel' => $searchModel, 'dataProvider' => $dataProvider]); ?>

<script type="text/javascript">

function toggleAttr()
{
    if ($('.is-attibute:checked').length > 0){
        $('.section-attribute').show();
    }
    else{
        $('.section-attribute').hide();
    }
        
}

function toggleNumber()
{
    $('.table-item tbody .row-item').each(function(){
        var attributeType = $(this).find(".attribute-type").val();
        if(attributeType != "<?=Attribute::TYPE_STRING?>"){
            // $(this).find(".attribute-value").addClass('angka');
        }
        else{
            // $(this).find(".attribute-value").removeClass('angka');
        }
    });
}

function addRow(id, attributeName, attributeType) 
{
    var index = 0;
    if (typeof $(".table-item .row-item").last().attr("id") != 'undefined')
        index = parseInt($(".table-item .row-item").last().attr("id").split("-")[1]) + 1;

    var clone = $(".table-template .row-item").clone().attr("id", "row-"+index);
    
    clone.html(function(i, oldTr) {return oldTr.replace(/\{index}/g, index);});

    clone.find(".attribute-id").val(id);
    clone.find(".attribute-name").val(attributeName);
    clone.find(".attribute-name-label").html(attributeName);
    clone.find(".attribute-type").val(attributeType);
    if(attributeType != "<?=Attribute::TYPE_STRING?>"){
        // clone.find(".attribute-value").addClass('angka');
    }
    else{
        // clone.find(".attribute-value").removeClass('angka');
    }
    
    $(".table-item").append(clone);
}

$(document).on("click", ".btn-add-attribute", function(e){
    var id = $(this).attr('id').split('-')[2];
    var attributeName = $(this).data('name');
    var attributeType = $(this).data('type');
    addRow(id, attributeName, attributeType);       
    e.preventDefault();
});

$(document).on("click", ".btn-remove", function(e){
    var tr = $(this).closest('tr');
    tr.remove();
});

$(document).on('pjax:complete', function(e) {
    $.pjax.defaults.timeout = 1000000;
    // $(".select2").select2();
    $('.datepicker').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY',
        clearButton: true,
        weekStart: 1,
        time: false
    });
});

$(document).ready(function(){
    $.pjax.defaults.timeout = 1000000;
    toggleNumber();
    toggleAttr();

    $(".is-attibute").on('ifChanged', function(e){
        toggleAttr();
    });
});

</script>