<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use app\components\BaseController;
use common\models\Member;
use common\models\Attribute;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackInnerButton('attributegroup', 'index', ['id' => $model->product_id]);
$toolbar[] = ButtonComponent::getUpdateButton($model->id);
    
BaseController::$toolbar = $toolbar;
    
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Product : <?=$model->product->product_name?></h4>
            </div>
            <div class="card-content">
                <div class="card-body">            
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('attribute_group_title')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->attribute_group_title) ? $model->attribute_group_title : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('group_label_id')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->groupLabel->group_label) ? $model->groupLabel->group_label : '-'?></div>
                    </div>  
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Attribute</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover table-item">
                            <thead>
                            <tr>
                                <th style="width: 50%;" class="text-center">Attribute</th>
                                <th style="width: 50%;" class="text-center">Value</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach($model->productAttributes as $i => $item):?>
                            <tr>
                                <td class="text-center"><?= $item->attribute0->attribute_name?></td>
                                <?php 
                                    $value = "";
                                    if($item->attribute0->attribute_type == Attribute::TYPE_INT){
                                        $value = $item->product_attribute_value_int;
                                    }
                                    if($item->attribute0->attribute_type == Attribute::TYPE_FLOAT){
                                        $value = $item->product_attribute_value_float;
                                    }
                                    if($item->attribute0->attribute_type == Attribute::TYPE_STRING){
                                        $value = $item->product_attribute_value_string;
                                    }
                                 ?>
                                <td class="text-center"><?= $value?></td>
                                
                            </tr>
                            <?php endforeach;?>        
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
