<?php

namespace admin\modules\setting\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\ForbiddenHttpException;
use app\components\BaseController;
use frontend\components\LabelComponent;
use frontend\models\UserSearch;
use common\components\ErrorGenerateComponent;
use common\models\User;
use common\models\Employee;
use common\models\Profile;
use yii\web\UploadedFile;
use yii\helpers\Url;
use yii\imagine\Image;  
use Imagine\Image\Box;

class ProfileController extends BaseController
{
    
	public function actionMyprofile()
	{
		BaseController::$page_caption = 'Profil Saya';

		$model = Profile::find()->andWhere('user_id=:id', [':id' => Yii::$app->user->id])->one();
		
		$tmpAvatar = "";
		if(!$model){
			$model = new Profile();
		}
		else{
			$tmpAvatar = $model->profile_avatar;
            $model->profile_address = !empty($model->profile_address) ? strip_tags($model->profile_address) : NULL;
		}

        if($model->load(Yii::$app->request->post())){
            
            $imagename = uniqid(rand());
            $model->image = NULL;
            $model->image  = UploadedFile::getInstanceByName('Profile[profile_avatar]');
            $model->profile_avatar = !empty($model->image) ? $imagename.'.'.$model->image->extension : $tmpAvatar;
            $model->profile_address = !empty($model->profile_address) ? nl2br($model->profile_address) : NULL;

            if(!empty($model->profile_name)){
                if(empty($model->profile_slug)){
                    $model->profile_slug = $model->slugify($model->profile_name);
                }
            }
            
            $model->user_id = Yii::$app->user->id;
            if ($model->save()) {
            	
            	
                
                if ($model->image) {
                    $urlImage = str_replace('/admin', '', Url::to('@app').'uploads/profiles/'.$imagename.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

            	Yii::$app->session->setFlash('success', 'Profile '.LabelComponent::SUCCESS_UPDATE);
            	return $this->redirect(['myprofile']);
            }else{
            	Yii::$app->session->setFlash('danger', 'Terjadi kesalahan saat update profile.');
            }

            $model->profile_address = !empty($model->profile_address) ? strip_tags($model->profile_address) : NULL;
        }
        
        return $this->render('myprofile', [
            'model' => $model,
        ]);
	}
}
