<?php

namespace admin\modules\setting\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\ForbiddenHttpException;
use app\components\BaseController;
use frontend\components\LabelComponent;
use frontend\models\UserSearch;
use common\components\ErrorGenerateComponent;
use common\models\User;

use common\models\Profile;
use common\models\ChangePassword;
use frontend\models\SignupForm;
use yii\web\UploadedFile;
use yii\imagine\Image;  
use Imagine\Image\Box;

class UserController extends BaseController
{
    public function actionIndex()
    {
		BaseController::$page_caption = 'User';
		
		$searchModel = new UserSearch();
		$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

		return $this->render('index', [
			'searchModel' => $searchModel,
			'dataProvider' => $dataProvider,
		]);
    }
	
	public function actionCreate()
    {
		BaseController::$page_caption = 'Tambah User';
		
		$model = new SignupForm;
		$modelProfile = new Profile;
		
        if ($model->load(Yii::$app->request->post())) {
			$transaction = Yii::$app->db->beginTransaction();
			
            if ($user = $model->signup()) {
				$auth = Yii::$app->authManager;
				
				foreach($model->roles as $roles) {
					$role = $auth->getRole($roles);
					$auth->assign($role, $user->id);
				}

				$modelProfile->attributes = $_POST['Profile'];
				$imagename = uniqid(rand());
	            $modelProfile->image = NULL;
	            $modelProfile->image  = UploadedFile::getInstanceByName('Profile[profile_avatar]');
	            $modelProfile->profile_avatar = !empty($modelProfile->image) ? $imagename.'.'.$modelProfile->image->extension : "";
				$modelProfile->user_id = $user->id;
				if ($modelProfile->save()) {
					$path = realpath(dirname(__FILE__).'/../../../../').'/uploads/profile';
                
	                if ($modelProfile->image) {
	                    $modelProfile->image->saveAs($path."/".$modelProfile->profile_avatar);
	                }
					$transaction->commit();
					Yii::$app->session->setFlash('success', 'User '.LabelComponent::SUCCESS_SAVE);
					return $this->redirect(['index']);
				}
				else {
					$errorString = ErrorGenerateComponent::generateErrorLabels($modelEmployee->getErrors());
					Yii::$app->session->setFlash('danger', 'Gagal membuat user karena kesalahan berikut: '.$errorString);
				}
            }
			
			$transaction->rollback();
        }
		
        return $this->render('form', [
			'model' => $model,
			'modelProfile' => $modelProfile,
		]);
    }
	
	public function actionUpdate($id)
    {
		BaseController::$page_caption = 'Update User';
		
		$user = $this->findModel($id);
		$model = new SignupForm();
		$model->scenario = SignupForm::SCENARIO_UPDATE_USER;
		$model->username = $user->username;
		$auth = Yii::$app->authManager;
		$roles = $auth->getRolesByUser($id);	
		foreach($roles as $role) {
			$model->roles[] = $role->name;
		}

		$modelProfile = isset($user->profiles[0]) ? Profile::find()->andWhere('id=:id', [':id' => $user->profiles[0]->id])->one() : new Profile;
		$tempAvatar = '';
		if($modelProfile)
			$tempAvatar = $modelProfile->profile_avatar;

		
        if ($model->load(Yii::$app->request->post())) {
			$transaction = Yii::$app->db->beginTransaction();
			
			$user->username = $model->username;
			if (!empty($model->password)) {
				$user->setPassword($model->password);
			}
			
            if ($user->save()) {
				$auth->revokeAll($id);
				foreach($model->roles as $roles) {
					$role = $auth->getRole($roles);
					$auth->assign($role, $user->id);
				}
				
				$modelProfile->attributes = $_POST['Profile'];

				$imagename = uniqid(rand());
	            $modelProfile->image = NULL;
	            $modelProfile->image  = UploadedFile::getInstanceByName('Profile[profile_avatar]');
	            $modelProfile->profile_avatar = !empty($modelProfile->image) ? $imagename.'.'.$modelProfile->image->extension : $tempAvatar;
				$modelProfile->user_id = $user->id;
				
				if ($modelProfile->save()) {
					$path = realpath(dirname(__FILE__).'/../../../../').'/uploads/profile';
                
	                if ($modelProfile->image) {
	                    $modelProfile->image->saveAs($path."/".$modelProfile->profile_avatar);
	                }

					$transaction->commit();
					Yii::$app->session->setFlash('success', 'User '.LabelComponent::SUCCESS_UPDATE);
					return $this->redirect(['index']);
				}
				else {
					$errorString = ErrorGenerateComponent::generateErrorLabels($modelEmployee->getErrors());
					Yii::$app->session->setFlash('danger', 'Gagal membuat user karena kesalahan berikut: '.$errorString);
				}
            }
			
			$transaction->rollback();
        }
		
        return $this->render('form', [
			'model' => $model,
			'user' => $user,
			'modelProfile' => $modelProfile,
		]);
    }
	
	public function actionDelete($id) 
	{
		$model = $this->findModel($id);
		if ($model) {
			$model->status = User::STATUS_DELETED;
			$model->update();
			
			Yii::$app->session->setFlash('success', 'User '.LabelComponent::SUCCESS_DELETE);
			return $this->redirect(['index']);
		}
	}

	
	public function actionChangepassword()
	{
		BaseController::$page_caption = 'Ganti Password';

        $modelUser = new ChangePassword();
        if ($modelUser->load(Yii::$app->getRequest()->post()) && $modelUser->change()) {
            //Yii::$app->user->logout();
            //return $this->goHome();
            Yii::$app->session->setFlash('success', 'Password '.LabelComponent::SUCCESS_UPDATE);
            return $this->redirect(['changepassword']);
        }
        return $this->render('changepassword', [
			'modelUser' => $modelUser,
        ]);
	}

    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('User '.LabelComponent::NOT_FOUND);
        }
    }
}
