<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
// use yii\widgets\ActiveForm;
use yii\bootstrap\ActiveForm;
use admin\components\LabelComponent;
// use frontend\components\AccessComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Store;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getSaveButton();
	
BaseController::$toolbar = $toolbar;
	
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form']); ?>
<?php //echo $form->errorSummary(array($model));?>

<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                	<?= $form->field($model, 'profile_name')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'profile_slug')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'profile_avatar')->fileInput(['class' => 'labelWidth']) ?>
                    <?php 
                        if(!empty($model->profile_avatar)){
                            $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/profiles/".$model->profile_avatar);
                            if(file_exists("../../uploads/profiles/".$model->profile_avatar)){
                                echo Html::img($urlImage, ['height' => '200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i><br><br>";
                            }
                        }
                     ?>
                    <?= $form->field($model, 'profile_gender')
                        ->dropDownList($model->getGenderLabels(), ['class' => 'form-control input-sm', 'prompt' => 'Pilih']);
                    ?>
                    <?= $form->field($model, 'profile_phone1')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'profile_phone2')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'profile_address')->textArea(['rows' => 4, 'class'=>'form-control input-sm']) ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>