<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
// use yii\widgets\ActiveForm;
use yii\bootstrap\ActiveForm;
use frontend\components\LabelComponent;
use frontend\components\AccessComponent;
use frontend\components\ButtonComponent;
use app\components\BaseController;
use common\models\Store;
use common\models\AuthItem;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();
	
BaseController::$toolbar = $toolbar;
	
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form']); ?>
<?php //echo $form->errorSummary(array($model));?>

<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-content">
            	<div class="card-header">
                    <h4 class="card-title">Datil</h4>
                    <a class="heading-elements-toggle"><i class="la la-ellipsis-v font-medium-3"></i></a>
                    <div class="heading-elements">
                        <ul class="list-inline mb-0">
                            <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                	<?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>
					<?= $form->field($model, 'password')->passwordInput() ?>
					<?= $form->field($model, 'roles')->dropDownList((new AuthItem)->loadArrayOfRoles(), ['class' => 'select2 form-control', 'multiple' => 'multiple']);?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-12">
        <div class="card">
        	<div class="card-header">
                <h4 class="card-title">Info Lain</h4>
                <a class="heading-elements-toggle"><i class="la la-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content">
                <div class="card-body">
                	<?= $form->field($modelProfile, 'profile_name')->textInput() ?>
                    <?= $form->field($modelProfile, 'profile_email')->textInput() ?>
                    <?= $form->field($modelProfile, 'profile_avatar')->fileInput() ?>
                    <?php if(isset($modelProfile->profile_avatar)): ?>
                        <?= Html::a('<span  class="">'.$modelProfile->profile_avatar.'</span>', Url::base(true).'/uploads/profile/'.$modelProfile->profile_avatar, ['target' => '_blank' ]) ?>
                    <?php endif; ?>
			     </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>