<?php

namespace admin\modules\slide\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Slide;
use admin\components\DeliveryCostComponent;
use admin\models\SlideSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex($id = NULL)
	{
		  BaseController::$page_caption = 'Slide';

		  $searchModel = new SlideSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      if(empty($id)){
          $model = new Slide();
      }
      else{
          $model = $this->findModel($id);
      }
      
      if ($model->load(Yii::$app->request->post())) {
          // $model->attributes = $_POST['Slide'];

          $imagename         = uniqid(rand());
          $model->image     = UploadedFile::getInstance($model, 'image');
          if(!empty($model->image)){
            $model->slide_image_filename   = $imagename.'.'.$model->image->extension;
          }

          if ($model->save()) {
              if(!empty($model->image)){
                $urlImage = str_replace('/admin', '', Url::to('@app').'uploads/slides/'.$imagename.'.'.$model->image->extension);
                $model->image->saveAs($urlImage);
              }

              Yii::$app->session->setFlash('success', 'Slide '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }
      }

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
          'model' => $model,
      ]);
	}

  public function actionDelete($id)
  {
      $this->findModel($id)->delete();

      Yii::$app->session->setFlash('success', 'Slide '.LabelComponent::SUCCESS_DELETE);

      return $this->redirect(['index']);
  }

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Slide::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
