<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use common\components\DateComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Slide;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>

<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Tambah Slide</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <?= $form->field($model, 'image')->fileInput(['class' => 'labelWidth']) ?>
                    <?php
                        if(!empty($model->slide_image_filename)){
                            $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/slides/".$model->slide_image_filename);
                            if(file_exists("../../uploads/slides/".$model->slide_image_filename)){
                                echo Html::img($urlImage, ['height' => '200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
                    <?= $form->field($model, 'slide_order')->textInput(['class'=>'form-control input-sm angka']) ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>

<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Daftar Slide</h4>
                </div>
                <div class="card-content">
                    <div class="card-body pt-0">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    [
                                        'attribute' => 'slide_image_filename',
                                        'label' => 'Image',
                                        'format' => 'raw',
                                        'value' => function($model) {
                                            $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/slides/".$model->slide_image_filename);
                                            $image = "";
                                            if(file_exists("../../uploads/slides/".$model->slide_image_filename)){
                                                $image = "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/slides/').$model->slide_image_filename."' alt='' style='max-width: 150px; max-height: 150px;'/>";
                                            }

                                            return $image;
                                        },
                                        'filter' => false,
                                    ],
                                    'slide_order',
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap;">{update}{delete}</div>',
                                        'buttons'  => [
                                            'update' => function ($url, $model) {
                                                $url = Url::to(['index', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                            },
                                            'delete' => function ($url, $model) {
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
