<?php

namespace admin\modules\voucher\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Member;
use common\models\Voucher;
use common\models\Order;
use common\models\OrderDetail;
use common\models\DeliveryProvince;
use common\models\DeliveryCity;
use admin\components\DeliveryCostComponent;
use admin\models\VoucherSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{
    /**
     * @inheritdoc
     */
    // public function behaviors()
    // {
    //     return [
    //         'verbs' => [
    //             'class' => VerbFilter::className(),
    //             'actions' => [
    //                 //'delete' => ['POST'],
    //             ],
    //         ],
    //     ];
    // }

  public function actionIndex()
	{
		  BaseController::$page_caption = 'Voucher';

		  $searchModel = new VoucherSearch();
      $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

      return $this->render('index', [
          'searchModel'  => $searchModel,
          'dataProvider' => $dataProvider,
      ]);
	}

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Voucher';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

	public function actionCreate()
	{
      BaseController::$page_caption = 'Add Voucher';

		  $model = new Voucher();
      $model->voucher_type = Voucher::TYPE_PERCENT;

      if ($model->load(Yii::$app->request->post())) {
          $noProblem = true;

          if(!empty($model->voucher_qty)){
              $model->voucher_qty_used = 0;
          }

          $model->voucher_from = !empty($model->voucher_from) ? date('Y-m-d H:i:s', strtotime($model->voucher_from)) : NULL;
          $model->voucher_to = !empty($model->voucher_to) ? date('Y-m-d H:i:s', strtotime($model->voucher_to)) : NULL;

          if(empty($model->voucher_from) && empty($model->voucher_to)){
              Yii::$app->session->setFlash('danger', 'Voucher date From and To cannot be null together.');
              $noProblem = false;
          }

          if(!empty($model->voucher_from) && !empty($model->voucher_to)){
              if($model->voucher_from > $model->voucher_to){
                  Yii::$app->session->setFlash('danger', 'From date must not exceed the To date.');
                  $noProblem = false;
              }
          }

          if ($model->is_use_min_order == "1" && empty($model->voucher_min_order)){
              Yii::$app->session->setFlash('danger', 'Min Order cannont be NULL.');
              $noProblem = false;
          }

          if ($model->is_use_qty == "1" && empty($model->voucher_qty)){
              Yii::$app->session->setFlash('danger', 'Qty cannont be NULL.');
              $noProblem = false;
          }

          if ($noProblem && $model->save()) {

              Yii::$app->session->setFlash('success', 'Voucher '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }

          $model->voucher_from = !empty($model->voucher_from) ? date('d-m-Y H:i', strtotime($model->voucher_from)) : NULL;
          $model->voucher_to = !empty($model->voucher_to) ? date('d-m-Y H:i', strtotime($model->voucher_to)) : NULL;
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'create',
      ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Voucher';

  		$model = $this->findModel($id);
      $model->is_use_min_order = !empty($model->voucher_min_order) ? 1 : 0;
      $model->is_use_qty = !empty($model->voucher_qty) ? 1 : 0;
      $model->voucher_from = !empty($model->voucher_from) ? date('d-m-Y H:i', strtotime($model->voucher_from)) : NULL;
      $model->voucher_to = !empty($model->voucher_to) ? date('d-m-Y H:i', strtotime($model->voucher_to)) : NULL;
      $model->voucher_min_order = !empty($model->voucher_min_order) ? round($model->voucher_min_order, 2) : NULL;
      

      if ($model->load(Yii::$app->request->post())) {
          $noProblem = true;

          if(!empty($model->voucher_qty) && empty($model->voucher_qty_used)){
              $model->voucher_qty_used = 0;
          }

          if(empty($model->voucher_qty)){
              $model->voucher_qty_used = NULL;
          }

          $model->voucher_from = !empty($model->voucher_from) ? date('Y-m-d H:i:s', strtotime($model->voucher_from)) : NULL;
          $model->voucher_to = !empty($model->voucher_to) ? date('Y-m-d H:i:s', strtotime($model->voucher_to)) : NULL;

          if(empty($model->voucher_from) && empty($model->voucher_to)){
              Yii::$app->session->setFlash('danger', 'Voucher date From and To cannot be null together.');
              $noProblem = false;
          }

          if(!empty($model->voucher_from) && !empty($model->voucher_to)){
              if($model->voucher_from > $model->voucher_to){
                  Yii::$app->session->setFlash('danger', 'From date must not exceed the To date.');
                  $noProblem = false;
              }
          }

          if ($model->is_use_min_order == "1" && empty($model->voucher_min_order)){
              Yii::$app->session->setFlash('danger', 'Min Order cannont be NULL.');
              $noProblem = false;
          }

          if ($model->is_use_qty == "1" && empty($model->voucher_qty)){
              Yii::$app->session->setFlash('danger', 'Qty cannont be NULL.');
              $noProblem = false;
          }

          if ($noProblem && $model->save()) {

              Yii::$app->session->setFlash('success', 'Voucher '.LabelComponent::SUCCESS_SAVE);
              return $this->redirect(['index']);
          }

          $model->voucher_from = !empty($model->voucher_from) ? date('d-m-Y H:i', strtotime($model->voucher_from)) : NULL;
          $model->voucher_to = !empty($model->voucher_to) ? date('d-m-Y H:i', strtotime($model->voucher_to)) : NULL;
      }

      return $this->render('form', [
         'model' => $model,
         'mode' => 'update',
      ]);
	}

	public function actionDelete($id)
	{
      $model = $this->findModel($id);
      if(!empty($model->orders)){
          Yii::$app->session->setFlash('Danger', 'Cannot delete Voucher because is used.');
      }
      else{
        $model->delete();
        Yii::$app->session->setFlash('success', 'Voucher '.LabelComponent::SUCCESS_DELETE);
      }

      return $this->redirect(['index']);
	}
    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Voucher::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
