<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Voucher;
use common\models\DeliveryProvince;
use common\models\DeliveryCity;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/voucher/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => true]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <?= $form->field($model, 'voucher_title')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'voucher_code')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'voucher_from')->textInput(['class'=>'form-control input-sm datetimepicker']) ?>
                    <?= $form->field($model, 'voucher_to')->textInput(['class'=>'form-control input-sm datetimepicker']) ?>
                    <?= $form->field($model, 'voucher_value')->textInput(['class'=>'form-control input-sm angka']) ?>
                    
                    <?= $form->field($model, 'is_use_min_order')->checkbox(['class' => 'i-checks is-use-min-order'])->label(false)?>
                    <div id="field-use-min-order">
                    <?= $form->field($model, 'voucher_min_order')->textInput(['class'=>'form-control input-sm angka'])->label(false) ?>
                    </div>

                    <?= $form->field($model, 'is_use_qty')->checkbox(['class' => 'i-checks is-use-qty'])->label(false)?>
                    <div id="field-use-qty">
                    <?= $form->field($model, 'voucher_qty')->textInput(['class'=>'form-control input-sm angka'])->label(false) ?>
                    </div>

                    <?= $form->field($model, 'voucher_type')->radioList($model->getTypeLabels(), ['class' => 'i-checks checkcox-payment']);?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>
<script type="text/javascript">

function toggleQty()
{
    if ($('.is-use-qty:checked').length > 0){
        $("#field-use-qty").show();
    }
    else{
        $("#field-use-qty").hide();
        $("#voucher-voucher_qty").val('');
    }
}

function toggleMinOrder()
{
    if ($('.is-use-min-order:checked').length > 0){
        $("#field-use-min-order").show();
    }
    else{
        $("#field-use-min-order").hide();
        $("#voucher-voucher_min_order").val('');
    }
}

$(document).ready(function(){
    toggleQty();
    toggleMinOrder();

    $(".is-use-qty").on('ifChanged', function(e){
        toggleQty();
    });

    $(".is-use-min-order").on('ifChanged', function(e){
        toggleMinOrder();
    });
});

</script>