<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Voucher;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-head">
                    
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    'voucher_title',
                                    'voucher_code',
                                    [
                                        'attribute' => 'voucher_from',
                                        'value' => function($model) {
                                            return !empty($model->voucher_from) ? date('d-m-Y H:i:s', strtotime($model->voucher_from)) : '';
                                        },
                                        'filter' => Html::activeTextInput($searchModel, 'start_date', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date', ['class' => 'form-control datepicker'])
                                    ],
                                    [
                                        'attribute' => 'voucher_to',
                                        'value' => function($model) {
                                            return !empty($model->voucher_to) ? date('d-m-Y H:i:s', strtotime($model->voucher_to)) : '';
                                        },
                                        'filter' => Html::activeTextInput($searchModel, 'start_date2', ['class' => 'form-control datepicker'])." hingga ".Html::activeTextInput($searchModel, 'end_date2', ['class' => 'form-control datepicker'])
                                    ],
                                    [
                                        'attribute' => 'voucher_type',
                                        'value' => function($model) {
                                            return $model->getTypeLabels($model->voucher_type);
                                        },
                                        'filter' => Html::activeDropDownList($searchModel, 'voucher_type', (new Voucher)->getTypeLabels(), ['class' => 'input-sm form-control', 'prompt' => LabelComponent::DROPDOWN_ALL])
                                    ],
                                    [
                                        'attribute' => 'voucher_value',
                                        'value' => function($model) {
                                            return CurrencyComponent::formatMoney($model->voucher_value);
                                        },
                                        'filter' => false,
                                    ],
                                    [
                                        'attribute' => 'voucher_min_order',
                                        'value' => function($model) {
                                            return !empty($model->voucher_min_order) ? CurrencyComponent::formatMoney($model->voucher_min_order) : '';
                                        },
                                        'filter' => false,
                                    ],
                                    [
                                        'attribute' => 'voucher_qty',
                                        'value' => function($model) {
                                            return $model->voucher_qty;
                                        },
                                        'filter' => false,
                                    ],
                                    [
                                        'attribute' => 'voucher_qty_used',
                                        'value' => function($model) {
                                            return $model->voucher_qty_used;
                                        },
                                        'filter' => false,
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="white-space: nowrap;">{update}{delete}</div>',
                                        'buttons'  => [
                                            'update' => function ($url, $model) {
                                                // if (AccessComponent::hasAccess(Yii::$app->controller->module->id, Yii::$app->controller->id, 'update')) {
                                                    $url = Url::to(['update', 'id' => $model->id]);
                                                    return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                                // }
                                                // return "";
                                            },
                                            'delete' => function ($url, $model) {
                                                // if (AccessComponent::hasAccess(Yii::$app->controller->module->id, Yii::$app->controller->id, 'delete')) {
                                                    $url = Url::to(['delete', 'id' => $model->id]);
                                                    return Html::a(
                                                        '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                        '#',
                                                        [
                                                            'title' => Yii::t('yii', 'Delete'),
                                                            'aria-label' => Yii::t('yii', 'Delete'),
                                                            'onclick' => "deleteclick('".$url."');"
                                                        ]
                                                    );
                                                // }
                                                // return "";
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
