<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use app\components\BaseController;
use common\models\Member;
use common\models\Order;


$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
    
BaseController::$toolbar = $toolbar;
    
foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/member/default">
<section class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Detail</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_email')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->member_email) ? $model->member_email : ''?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_fullname')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->member_fullname) ? $model->member_fullname : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_is_verified')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=$model->member_is_verified == 0 ? 'Not Yet' : 'Yes'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_status')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->member_status) ? $model->getStatusLabels($model->member_status) : '-'?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('created_on')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->created_on) ? DateComponent::getHumanizedDate($model->created_on) : '-'?></div>
                    </div>  
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Contacts</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_address')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->member_address) ? $model->member_address : ''?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('province_id')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=isset($model->province_name) ? $model->province_name : '-'?></div>
                    </div>  
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('city_id')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->city_name) ? $model->city_name : ''?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-lg-4"><b><?=$model->getAttributeLabel('member_phone')?></b></div>
                        <div class="col-lg-1">:</div>
                        <div class="col-lg-7"><?=!empty($model->member_phone) ? $model->member_phone : '-'?></div>
                    </div>  
                </div>
            </div>
        </div>
    </div>
</section>
<?php if(!empty($model->orders)): ?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Orders</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover table-item">
                            <thead>
                            <tr>
                                <th><?= (new Order)->getAttributeLabel('order_code') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_date') ?></th>
                                <th>Ship To</th>
                                <th><?= (new Order)->getAttributeLabel('order_recipient_phone') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_recipient_email') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_subtotal') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_shipping_fee') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_grand_total') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_payment_method') ?></th>
                                <th><?= (new Order)->getAttributeLabel('order_status') ?></th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach($model->orders as $i => $item):?>
                            <tr>
                                <td><?= $item->order_code?></td>
                                <td><?= DateComponent::getHumanizedDate($item->order_date)?></td>
                                <td style="white-space: nowrap;"><?= $item->order_recipient_fullname.', '.$item->order_recipient_address.', '.$item->order_recipient_province_name.', '.$item->order_recipient_city_name?></td>
                                <td><?= $item->order_recipient_phone?></td>
                                <td><?= $item->order_recipient_email?></td>
                                <td><?= CurrencyComponent::formatMoney($item->order_subtotal)?></td>
                                <td><?= CurrencyComponent::formatMoney($item->order_shipping_fee)?></td>
                                <td><?= CurrencyComponent::formatMoney($item->order_grand_total)?></td>
                                <td><?= $item->getMethodLabels($item->order_payment_method)?></td>
                                <td><?= $item->getStatusLabels($item->order_status)?></td>
                                <td><button type="button" class="btn btn-outline-success btn-sm btn-view-detail" id="id-order-<?=$item->id?>" data-toggle="modal" data-target="#modal-order"><i class="la la-binoculars"></i></button></td>
                            </tr>
                            <?php endforeach;?>        
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?= Yii::$app->view->render('_orderdetail'); ?>
<?php endif; ?>
<script type="text/javascript">
$(document).ready(function(){
    $(".btn-view-detail").click(function(e){
        var baseUrl = $('#baseUrl').val();
        id = $(this).attr('id').split('-')[2];
        
        $(".table-detail tbody .row-item").remove();
        $.post(baseUrl+'/getorderdetail', {'id': id}, function(response){
            $.each(response, function(k, v){
                var tr = '<tr class="row-item">'+
                                '<td>'+v.product_name+'</td>'+
                                '<td>'+v.attribute+'</td>'+
                                '<td>'+v.detail_qty+'</td>'+
                                '<td>'+v.detail_price+'</td>'+
                                '<td>'+v.detail_subtotal+'</td>'+
                            '</tr>';
                
                $(".table-detail tbody").append(tr);
            });
        }, 'json');
        
    });
});

</script>