<?php 
namespace admin\components;

use Yii;
use yii\base\Component;
use common\models\AuthItem;

class AccessComponent extends Component
{
	public static function hasAccess($module, $controller, $action)
	{
		if ($module && $controller && $action)
		{
			$module = str_replace('/', '.', $module);
			$operation = $module . '.' . $controller . '.' . $action;
			
			return (array_key_exists('Super Administrator', Yii::$app->authManager->getRolesByUser(Yii::$app->user->id)) || \Yii::$app->user->can($operation));
		}
		return false;
	}
	
	public static function getArrOfAccess()
	{
		return [
			'customer' => [
				'label' => 'Ads Banner',
				'value' => (new AuthItem)->getPermissionsByModule('ads')
			],
			'supplier' => [
				'label' => 'News', 
				'value' => (new AuthItem)->getPermissionsByModule('news'),
			],
			'product' => [
				'label' => 'Video',
				'value' => (new AuthItem)->getPermissionsByModule('video'),
			],
			'discmaster' => [
				'label' => 'Merchandise',
				'value' => (new AuthItem)->getPermissionsByModule('merchandise'),
			],
			'bank' => [
				'label' => 'Match',
				'value' => (new AuthItem)->getPermissionsByModule('match')
			],
			'store' => [
				'label' => 'Ticket',
				'value' => (new AuthItem)->getPermissionsByModule('ticket'),
			],
			'warehouse' => [
				'label' => 'Team',
				'value' => (new AuthItem)->getPermissionsByModule('team'),
			],
			'setting' => [
				'label' => 'Setting',
				'value' => (new AuthItem)->getPermissionsByModule('setting'),
			],
		];
	}
}