<?php
namespace admin\components;

use Yii;
use yii\base\Component;
// use admin\components\AccessComponent;

class MenuComponent extends Component{

	public static function getArrOfMenu($currentController = '', $currentAction = '', $currentModule = '')
	{
		return array(
			array(
				'label' => 'Dashboard',
				'url' => 'dashboard',
				'icon' => 'mbri-home',
				'active' => $currentController == 'dashboard' || $currentAction == "myprofile" ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Articles',
				'url' => '#',
				'icon' => 'mbri-change-style',
				'active' => $currentModule == 'article' ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'Categories',
						'url' => 'article/category',
						'icon' => 'mbri-features',
						'active' => $currentModule == 'article' && $currentController == 'category' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Articles',
						'url' => 'article/default',
						'icon' => 'mbri-change-style',
						'active' => $currentModule == 'article' && $currentController == 'default' ? true : false,
						'visible' => true
					],
				),
			),
			array(
				'label' => 'About Us',
				'url' => '#',
				'icon' => 'mbri-pin',
				'active' => $currentModule == 'brand' || $currentModule == 'milestone' || $currentModule == 'certification' ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'Brand',
						'url' => 'brand',
						'icon' => 'mbri-windows',
						'active' => $currentModule == 'brand' ? true : false,
						'visible' => true,
					],
					[
						'label' => 'Milestone',
						'url' => 'milestone',
						'icon' => 'mbri-calendar',
						'active' => $currentModule == 'milestone' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Certification',
						'url' => 'certification',
						'icon' => 'mbri-bookmark',
						'active' => $currentModule == 'certification' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Facility',
						'url' => 'facility',
						'icon' => 'mbri-magic-stick',
						'active' => $currentModule == 'facility' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Subsidiary',
						'url' => 'subsidiary',
						'icon' => 'mbri-add-submenu',
						'active' => $currentModule == 'subsidiary' ? true : false,
						'visible' => true
					],
				),
			),
			array(
				'label' => 'Slide',
				'url' => 'slide',
				'icon' => 'mbri-image-slider',
				'active' => $currentModule == 'slide' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Distribution',
				'url' => '#',
				'icon' => 'mbri-delivery',
				'active' => $currentModule == 'distribution' ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'Local',
						'url' => 'distribution/default',
						'icon' => 'mbri-delivery',
						'active' => $currentModule == 'brand' && $currentController == 'default' ? true : false,
						'visible' => true,
					],
					[
						'label' => 'International',
						'url' => 'distribution/international',
						'icon' => 'mbri-delivery',
						'active' => $currentModule == 'distribution' && $currentController == 'international' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Segmentation',
						'url' => 'distribution/segmentation',
						'icon' => 'mbri-layers',
						'active' => $currentModule == 'distribution' && $currentController == 'segmentation' ? true : false,
						'visible' => true
					],
				),
			),
			array(
				'label' => 'Product Category',
				'url' => 'productcategory',
				'icon' => 'mbri-database',
				'active' => $currentModule == 'productcategory' ? true : false,
				'visible' => true,
			),
			array(
				'label' => 'Setting',
				'url' => '#',
				'icon' => 'mbri-setting',
				'active' => in_array($currentModule, array('setting')) ? true : false,
				'visible' => true,
				'items' => array(
					[
						'label' => 'Setting',
						'url' => 'setting',
						'icon' => 'la la-gear',
						'active' => $currentModule == 'setting' && $currentController == 'default' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Profil',
						'url' => 'setting/profile/myprofile',
						'icon' => 'la la-user',
						'active' => $currentModule == 'setting' && $currentController == 'profile' ? true : false,
						'visible' => true
					],
					[
						'label' => 'Ganti Password',
						'url' => 'setting/user/changepassword',
						'icon' => 'la la-key',
						'active' => $currentModule == 'setting' && $currentController == 'user' ? true : false,
						'visible' => true,
					],
					[
						'label' => 'Backup',
						'url' => 'setting/backup',
						'icon' => 'la la-save',
						'active' => $currentModule == 'setting' && $currentController == 'backup' ? true : false,
						'visible' => true,
					],
					[
						'label' => 'Logout',
						'url' => 'site/logout',
						'icon' => 'la la-sign-out',
						'visible' => true,
					],
				),
			),
		);
	}
}
